/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.completable.CompletableMerge;
import io.reactivex.internal.queue.MpscLinkedQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(final CompletableObserver s) {
        Iterator<? extends CompletableSource> iterator;
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onError(e);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final MpscLinkedQueue<Throwable> queue = new MpscLinkedQueue<Throwable>();
        while (true) {
            CompletableSource c;
            boolean b;
            if (set.isDisposed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onComplete();
                    } else {
                        s.onError(CompletableMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (!b) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onComplete();
                    } else {
                        s.onError(CompletableMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (set.isDisposed()) {
                return;
            }
            if (c == null) {
                NullPointerException e = new NullPointerException("A completable source is null");
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onComplete();
                    } else {
                        s.onError(CompletableMerge.collectErrors(queue));
                    }
                }
                return;
            }
            wip.getAndIncrement();
            c.subscribe(new CompletableObserver(){

                @Override
                public void onSubscribe(Disposable d) {
                    set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    queue.offer(e);
                    this.tryTerminate();
                }

                @Override
                public void onComplete() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (queue.isEmpty()) {
                            s.onComplete();
                        } else {
                            s.onError(CompletableMerge.collectErrors(queue));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (queue.isEmpty()) {
                s.onComplete();
            } else {
                s.onError(CompletableMerge.collectErrors(queue));
            }
        }
    }
}

