/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposables;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableFromPublisher<T>
extends Completable {
    final Publisher<T> flowable;

    public CompletableFromPublisher(Publisher<T> flowable) {
        this.flowable = flowable;
    }

    @Override
    protected void subscribeActual(final CompletableObserver cs) {
        this.flowable.subscribe(new Subscriber<T>(){

            public void onComplete() {
                cs.onComplete();
            }

            public void onError(Throwable t) {
                cs.onError(t);
            }

            public void onNext(T t) {
            }

            public void onSubscribe(Subscription s) {
                cs.onSubscribe(Disposables.from(s));
                s.request(Long.MAX_VALUE);
            }
        });
    }
}

