/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableCreate
extends Completable {
    final CompletableOnSubscribe source;

    public CompletableCreate(CompletableOnSubscribe source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        Emitter parent = new Emitter(s);
        s.onSubscribe(parent);
        try {
            this.source.subscribe(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            parent.onError(ex);
        }
    }

    static final class Emitter
    extends AtomicReference<Disposable>
    implements CompletableEmitter,
    Disposable {
        final CompletableObserver actual;
        private static final long serialVersionUID = -2467358622224974244L;

        public Emitter(CompletableObserver actual) {
            this.actual = actual;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            Disposable d;
            if (this.get() != DisposableHelper.DISPOSED && (d = this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.actual.onComplete();
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            Disposable d;
            if (t == null) {
                t = new NullPointerException();
            }
            if (this.get() != DisposableHelper.DISPOSED && (d = this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.actual.onError(t);
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
                return;
            }
            RxJavaPlugins.onError(t);
        }

        @Override
        public void setDisposable(Disposable d) {
            DisposableHelper.set(this, d);
        }

        @Override
        public void setCancellable(Cancellable c) {
            this.setDisposable(new CancellableDisposable(c));
        }

        @Override
        public boolean isCancelled() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }
}

