/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.android.plugins;

import io.reactivex.Scheduler;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;

public final class RxAndroidPlugins {
    private static volatile Function<Scheduler, Scheduler> onInitMainThreadHandler;
    private static volatile Function<Scheduler, Scheduler> onMainThreadHandler;

    public static void setInitMainThreadSchedulerHandler(Function<Scheduler, Scheduler> handler) {
        onInitMainThreadHandler = handler;
    }

    public static Scheduler initMainThreadScheduler(Scheduler scheduler) {
        Function<Scheduler, Scheduler> f = onInitMainThreadHandler;
        if (f == null) {
            return scheduler;
        }
        try {
            return (Scheduler)f.apply((Object)scheduler);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void setMainThreadSchedulerHandler(Function<Scheduler, Scheduler> handler) {
        onMainThreadHandler = handler;
    }

    public static Scheduler onMainThreadScheduler(Scheduler scheduler) {
        Function<Scheduler, Scheduler> f = onMainThreadHandler;
        if (f == null) {
            return scheduler;
        }
        try {
            return (Scheduler)f.apply((Object)scheduler);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void reset() {
        RxAndroidPlugins.setInitMainThreadSchedulerHandler(null);
        RxAndroidPlugins.setMainThreadSchedulerHandler(null);
    }

    private RxAndroidPlugins() {
        throw new AssertionError((Object)"No instances.");
    }
}

