/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Emitter;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.subscriptions.CancellableSubscription;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import rx.internal.util.unsafe.SpscUnboundedArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.SerialSubscription;

public final class OnSubscribeCreate<T>
implements Observable.OnSubscribe<T> {
    final Action1<Emitter<T>> Emitter;
    final Emitter.BackpressureMode backpressure;

    public OnSubscribeCreate(Action1<Emitter<T>> Emitter2, Emitter.BackpressureMode backpressure) {
        this.Emitter = Emitter2;
        this.backpressure = backpressure;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        BaseEmitter emitter;
        switch (this.backpressure) {
            case NONE: {
                emitter = new NoneEmitter<T>(t);
                break;
            }
            case ERROR: {
                emitter = new ErrorEmitter<T>(t);
                break;
            }
            case DROP: {
                emitter = new DropEmitter<T>(t);
                break;
            }
            case LATEST: {
                emitter = new LatestEmitter<T>(t);
                break;
            }
            default: {
                emitter = new BufferEmitter<T>(t, RxRingBuffer.SIZE);
            }
        }
        t.add(emitter);
        t.setProducer(emitter);
        this.Emitter.call(emitter);
    }

    static final class LatestEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<Object> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();

        public LatestEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            this.queue.set(NotificationLite.next(t));
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            AtomicReference<Object> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(NotificationLite.getValue(o));
                }
                if (e == r) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureUtils.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final Queue<Object> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        public BufferEmitter(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscUnboundedArrayQueue(capacityHint) : new SpscUnboundedAtomicArrayQueue(capacityHint);
            this.wip = new AtomicInteger();
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(NotificationLite.next(t));
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            Queue<Object> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (a.isUnsubscribed()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    Object o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(NotificationLite.getValue(o));
                }
                if (e == r) {
                    if (a.isUnsubscribed()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.onError(ex);
                        } else {
                            super.onCompleted();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureUtils.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class ErrorEmitter<T>
    extends NoOverflowBaseEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;
        private boolean done;

        public ErrorEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            super.onNext(t);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            super.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError(e);
                return;
            }
            this.done = true;
            super.onError(e);
        }

        @Override
        void onOverflow() {
            this.onError(new MissingBackpressureException("create: could not emit value due to lack of requests"));
        }
    }

    static final class DropEmitter<T>
    extends NoOverflowBaseEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        public DropEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        public NoOverflowBaseEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            if (this.get() != 0L) {
                this.actual.onNext(t);
                BackpressureUtils.produced(this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class NoneEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        public NoneEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            long r;
            if (this.actual.isUnsubscribed()) {
                return;
            }
            this.actual.onNext(t);
            while ((r = this.get()) != 0L && !this.compareAndSet(r, r - 1L)) {
            }
        }
    }

    static abstract class BaseEmitter<T>
    extends AtomicLong
    implements Emitter<T>,
    Producer,
    Subscription {
        private static final long serialVersionUID = 7326289992464377023L;
        final Subscriber<? super T> actual;
        final SerialSubscription serial;

        public BaseEmitter(Subscriber<? super T> actual) {
            this.actual = actual;
            this.serial = new SerialSubscription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            try {
                this.actual.onCompleted();
            }
            finally {
                this.serial.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (this.actual.isUnsubscribed()) {
                return;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.serial.unsubscribe();
            }
        }

        @Override
        public final void unsubscribe() {
            this.serial.unsubscribe();
            this.onUnsubscribed();
        }

        void onUnsubscribed() {
        }

        @Override
        public final boolean isUnsubscribed() {
            return this.serial.isUnsubscribed();
        }

        @Override
        public final void request(long n) {
            if (BackpressureUtils.validate(n)) {
                BackpressureUtils.getAndAddRequest(this, n);
                this.onRequested();
            }
        }

        void onRequested() {
        }

        @Override
        public final void setSubscription(Subscription s) {
            this.serial.set(s);
        }

        @Override
        public final void setCancellation(Cancellable c) {
            this.setSubscription(new CancellableSubscription(c));
        }

        @Override
        public final long requested() {
            return this.get();
        }
    }
}

