/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.ProducerArbiter;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.UtilityFunctions;
import rx.observables.GroupedObservable;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.Subscriptions;

public final class OperatorGroupBy<T, K, V>
implements Observable.Operator<GroupedObservable<K, V>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector) {
        this(keySelector, UtilityFunctions.identity(), RxRingBuffer.SIZE, false);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(keySelector, valueSelector, RxRingBuffer.SIZE, false);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, V>> t) {
        final GroupBySubscriber<? super T, ? extends K, ? extends V> parent = new GroupBySubscriber<T, K, V>(t, this.keySelector, this.valueSelector, this.bufferSize, this.delayError);
        t.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                parent.cancel();
            }
        }));
        t.setProducer(parent.producer);
        return parent;
    }

    static final class State<T, K>
    extends AtomicInteger
    implements Producer,
    Subscription,
    Observable.OnSubscribe<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        volatile long requested;
        static final AtomicLongFieldUpdater<State> REQUESTED = AtomicLongFieldUpdater.newUpdater(State.class, "requested");
        volatile boolean done;
        Throwable error;
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<State> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(State.class, "cancelled");
        volatile Subscriber<? super T> actual;
        static final AtomicReferenceFieldUpdater<State, Subscriber> ACTUAL = AtomicReferenceFieldUpdater.newUpdater(State.class, Subscriber.class, "actual");
        volatile int once;
        static final AtomicIntegerFieldUpdater<State> ONCE = AtomicIntegerFieldUpdater.newUpdater(State.class, "once");

        public State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key, boolean delayError) {
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(REQUESTED, this, n);
                this.drain();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancelled != 0;
        }

        @Override
        public void unsubscribe() {
            if (CANCELLED.compareAndSet(this, 0, 1) && this.getAndIncrement() == 0) {
                this.parent.cancel(this.key);
            }
        }

        @Override
        public void call(Subscriber<? super T> s) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                s.add(this);
                s.setProducer(this);
                ACTUAL.lazySet(this, s);
                this.drain();
            } else {
                s.onError(new IllegalStateException("Only one Subscriber allowed!"));
            }
        }

        public void onNext(T t) {
            if (t == null) {
                this.error = new NullPointerException();
                this.done = true;
            } else {
                this.queue.offer(NotificationLite.instance().next(t));
            }
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<Object> q = this.queue;
            boolean delayError = this.delayError;
            Subscriber a = this.actual;
            NotificationLite nl = NotificationLite.instance();
            while (true) {
                if (a != null) {
                    if (this.checkTerminated(this.done, q.isEmpty(), a, delayError)) {
                        return;
                    }
                    long r = this.requested;
                    boolean unbounded = r == Long.MAX_VALUE;
                    long e = 0L;
                    while (r != 0L) {
                        boolean empty;
                        boolean d = this.done;
                        Object v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a, delayError)) {
                            return;
                        }
                        if (empty) break;
                        a.onNext(nl.getValue(v));
                        --r;
                        --e;
                    }
                    if (e != 0L) {
                        if (!unbounded) {
                            REQUESTED.addAndGet(this, e);
                        }
                        this.parent.s.request(-e);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.actual;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, boolean delayError) {
            if (this.cancelled != 0) {
                this.queue.clear();
                this.parent.cancel(this.key);
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onCompleted();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onCompleted();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedObservable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new GroupedUnicast<K, T>(key, state);
        }

        protected GroupedUnicast(K key, State<T, K> state) {
            super(key, state);
            this.state = state;
        }

        public void onNext(T t) {
            this.state.onNext(t);
        }

        public void onError(Throwable e) {
            this.state.onError(e);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends Subscriber<T> {
        final Subscriber<? super GroupedObservable<K, V>> actual;
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final boolean delayError;
        final Map<Object, GroupedUnicast<K, V>> groups;
        final Queue<GroupedObservable<K, V>> queue;
        final GroupByProducer producer;
        static final Object NULL_KEY = new Object();
        final ProducerArbiter s;
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "cancelled");
        volatile long requested;
        static final AtomicLongFieldUpdater<GroupBySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(GroupBySubscriber.class, "requested");
        volatile int groupCount;
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> GROUP_COUNT = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "groupCount");
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "wip");

        public GroupBySubscriber(Subscriber<? super GroupedObservable<K, V>> actual, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.groups = new ConcurrentHashMap<Object, GroupedUnicast<K, V>>();
            this.queue = new ConcurrentLinkedQueue<GroupedObservable<K, V>>();
            GROUP_COUNT.lazySet(this, 1);
            this.s = new ProducerArbiter();
            this.s.request(bufferSize);
            this.producer = new GroupByProducer(this);
        }

        @Override
        public void setProducer(Producer s) {
            this.s.setProducer(s);
        }

        @Override
        public void onNext(T t) {
            V v;
            K key;
            if (this.done) {
                return;
            }
            Queue<GroupedObservable<K, V>> q = this.queue;
            Subscriber<? super GroupedObservable<K, V>> a = this.actual;
            try {
                key = this.keySelector.call(t);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            boolean notNew = true;
            Object mapKey = key != null ? key : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.cancelled == 0) {
                    group = GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
                    this.groups.put(mapKey, group);
                    GROUP_COUNT.getAndIncrement(this);
                    notNew = false;
                    q.offer(group);
                    this.drain();
                } else {
                    return;
                }
            }
            try {
                v = this.valueSelector.call(t);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            group.onNext(v);
            if (notNew) {
                this.s.request(1L);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
                return;
            }
            this.error = t;
            this.done = true;
            GROUP_COUNT.decrementAndGet(this);
            this.drain();
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            GROUP_COUNT.decrementAndGet(this);
            this.drain();
        }

        public void requestMore(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            BackpressureUtils.getAndAddRequest(REQUESTED, this, n);
            this.drain();
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1) && GROUP_COUNT.decrementAndGet(this) == 0) {
                this.unsubscribe();
            }
        }

        public void cancel(K key) {
            Object mapKey;
            Object object = mapKey = key != null ? key : NULL_KEY;
            if (this.groups.remove(mapKey) != null && GROUP_COUNT.decrementAndGet(this) == 0) {
                this.unsubscribe();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Queue<GroupedObservable<K, V>> q = this.queue;
            Subscriber<GroupedObservable<K, V>> a = this.actual;
            do {
                if (this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                long r = this.requested;
                boolean unbounded = r == Long.MAX_VALUE;
                long e = 0L;
                while (r != 0L) {
                    boolean empty;
                    boolean d = this.done;
                    GroupedObservable<K, V> t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                    --r;
                    --e;
                }
                if (e == 0L) continue;
                if (!unbounded) {
                    REQUESTED.addAndGet(this, e);
                }
                this.s.request(-e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void errorAll(Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q, Throwable ex) {
            q.clear();
            ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
            this.groups.clear();
            for (GroupedUnicast groupedUnicast : list) {
                groupedUnicast.onError(ex);
            }
            a.onError(ex);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q) {
            if (d) {
                Throwable err = this.error;
                if (err != null) {
                    this.errorAll(a, q, err);
                    return true;
                }
                if (empty) {
                    ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
                    this.groups.clear();
                    for (GroupedUnicast groupedUnicast : list) {
                        groupedUnicast.onComplete();
                    }
                    this.actual.onCompleted();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class GroupByProducer
    implements Producer {
        final GroupBySubscriber<?, ?, ?> parent;

        public GroupByProducer(GroupBySubscriber<?, ?, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            this.parent.requestMore(n);
        }
    }
}

