/*
 * Decompiled with CFR 0.152.
 */
package rx;

import rx.Observer;
import rx.Producer;
import rx.Subscription;
import rx.internal.util.SubscriptionList;

public abstract class Subscriber<T>
implements Observer<T>,
Subscription {
    private final SubscriptionList cs;
    private final Subscriber<?> op;
    private Producer p;
    private long requested = Long.MIN_VALUE;

    protected Subscriber() {
        this.op = null;
        this.cs = new SubscriptionList();
    }

    protected Subscriber(Subscriber<?> op) {
        this.op = op;
        this.cs = op.cs;
    }

    public final void add(Subscription s) {
        this.cs.add(s);
    }

    @Override
    public final void unsubscribe() {
        this.cs.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.cs.isUnsubscribed();
    }

    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("number requested cannot be negative: " + n);
        }
        Producer shouldRequest = null;
        Subscriber subscriber = this;
        synchronized (subscriber) {
            if (this.p != null) {
                shouldRequest = this.p;
            } else {
                long total;
                this.requested = this.requested == Long.MIN_VALUE ? n : ((total = this.requested + n) < 0L ? Long.MAX_VALUE : total);
            }
        }
        if (shouldRequest != null) {
            shouldRequest.request(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer producer) {
        long toRequest;
        boolean setProducer = false;
        Subscriber subscriber = this;
        synchronized (subscriber) {
            toRequest = this.requested;
            this.p = producer;
            if (this.op != null && toRequest == Long.MIN_VALUE) {
                setProducer = true;
            }
        }
        if (setProducer) {
            this.op.setProducer(this.p);
        } else if (toRequest == Long.MIN_VALUE) {
            this.p.request(Long.MAX_VALUE);
        } else {
            this.p.request(toRequest);
        }
    }
}

