/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subscriptions.Subscriptions;

public final class OnSubscribeUsing<T, Resource>
implements Observable.OnSubscribe<T> {
    private final Func0<Resource> resourceFactory;
    private final Func1<? super Resource, ? extends Observable<? extends T>> observableFactory;
    private final Action1<? super Resource> dispose;

    public OnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Observable<? extends T>> observableFactory, Action1<? super Resource> dispose) {
        this.resourceFactory = resourceFactory;
        this.observableFactory = observableFactory;
        this.dispose = dispose;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        try {
            final Resource resource = this.resourceFactory.call();
            subscriber.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    OnSubscribeUsing.this.dispose.call(resource);
                }
            }));
            Observable<T> observable = this.observableFactory.call(resource);
            observable.subscribe(subscriber);
        }
        catch (Throwable e) {
            subscriber.unsubscribe();
            subscriber.onError(e);
        }
    }
}

