/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.functions.Functions;
import rx.internal.util.RxRingBuffer;
import rx.subscriptions.CompositeSubscription;

public final class OperatorZip<R>
implements Observable.Operator<R, Observable<?>[]> {
    final FuncN<? extends R> zipFunction;

    public OperatorZip(FuncN<? extends R> f) {
        this.zipFunction = f;
    }

    public OperatorZip(Func2 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func3 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func4 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func5 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func6 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func7 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func8 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    public OperatorZip(Func9 f) {
        this.zipFunction = Functions.fromFunc(f);
    }

    @Override
    public Subscriber<? super Observable[]> call(Subscriber<? super R> child) {
        Zip<? extends R> zipper = new Zip<R>(child, this.zipFunction);
        ZipProducer<? extends R> producer = new ZipProducer<R>(zipper);
        child.setProducer(producer);
        ZipSubscriber subscriber = new ZipSubscriber(child, zipper, producer);
        return subscriber;
    }

    private static final class Zip<R> {
        private final Observer<? super R> child;
        private final FuncN<? extends R> zipFunction;
        private final CompositeSubscription childSubscription = new CompositeSubscription();
        volatile long counter;
        static final AtomicLongFieldUpdater<Zip> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(Zip.class, "counter");
        static final int THRESHOLD = (int)((double)RxRingBuffer.SIZE * 0.7);
        int emitted = 0;
        private Object[] observers;
        private AtomicLong requested;

        public Zip(Subscriber<? super R> child, FuncN<? extends R> zipFunction) {
            this.child = child;
            this.zipFunction = zipFunction;
            child.add(this.childSubscription);
        }

        public void start(Observable[] os, AtomicLong requested) {
            int i;
            this.observers = new Object[os.length];
            this.requested = requested;
            for (i = 0; i < os.length; ++i) {
                InnerSubscriber io = new InnerSubscriber();
                this.observers[i] = io;
                this.childSubscription.add(io);
            }
            for (i = 0; i < os.length; ++i) {
                os[i].unsafeSubscribe((InnerSubscriber)this.observers[i]);
            }
        }

        void tick() {
            if (this.observers == null) {
                return;
            }
            if (COUNTER_UPDATER.getAndIncrement(this) == 0L) {
                while (true) {
                    if (this.requested.get() > 0L) {
                        Object[] vs = new Object[this.observers.length];
                        boolean allHaveValues = true;
                        for (int i = 0; i < this.observers.length; ++i) {
                            RxRingBuffer buffer = ((InnerSubscriber)this.observers[i]).items;
                            Object n = buffer.peek();
                            if (n == null) {
                                allHaveValues = false;
                                continue;
                            }
                            if (buffer.isCompleted(n)) {
                                this.child.onCompleted();
                                this.childSubscription.unsubscribe();
                                return;
                            }
                            vs[i] = buffer.getValue(n);
                        }
                        if (allHaveValues) {
                            try {
                                this.child.onNext(this.zipFunction.call(vs));
                                this.requested.decrementAndGet();
                                ++this.emitted;
                            }
                            catch (Throwable e) {
                                this.child.onError(OnErrorThrowable.addValueAsLastCause(e, vs));
                                return;
                            }
                            for (Object obj : this.observers) {
                                RxRingBuffer buffer = ((InnerSubscriber)obj).items;
                                buffer.poll();
                                if (!buffer.isCompleted(buffer.peek())) continue;
                                this.child.onCompleted();
                                this.childSubscription.unsubscribe();
                                return;
                            }
                            if (this.emitted <= THRESHOLD) continue;
                            for (Object obj : this.observers) {
                                ((InnerSubscriber)obj).requestMore(this.emitted);
                            }
                            this.emitted = 0;
                            continue;
                        }
                    }
                    if (COUNTER_UPDATER.decrementAndGet(this) <= 0L) break;
                }
            }
        }

        final class InnerSubscriber
        extends Subscriber {
            final RxRingBuffer items = RxRingBuffer.getSpmcInstance();

            InnerSubscriber() {
            }

            @Override
            public void onStart() {
                this.request(RxRingBuffer.SIZE);
            }

            public void requestMore(long n) {
                this.request(n);
            }

            @Override
            public void onCompleted() {
                this.items.onCompleted();
                Zip.this.tick();
            }

            @Override
            public void onError(Throwable e) {
                Zip.this.child.onError(e);
            }

            @Override
            public void onNext(Object t) {
                try {
                    this.items.onNext(t);
                }
                catch (MissingBackpressureException e) {
                    this.onError(e);
                }
                Zip.this.tick();
            }
        }
    }

    private static final class ZipProducer<R>
    extends AtomicLong
    implements Producer {
        private Zip<R> zipper;

        public ZipProducer(Zip<R> zipper) {
            this.zipper = zipper;
        }

        @Override
        public void request(long n) {
            this.addAndGet(n);
            this.zipper.tick();
        }
    }

    private final class ZipSubscriber
    extends Subscriber<Observable[]> {
        final Subscriber<? super R> child;
        final Zip<R> zipper;
        final ZipProducer<R> producer;
        boolean started;

        public ZipSubscriber(Subscriber<? super R> child, Zip<R> zipper, ZipProducer<R> producer) {
            super(child);
            this.started = false;
            this.child = child;
            this.zipper = zipper;
            this.producer = producer;
        }

        @Override
        public void onCompleted() {
            if (!this.started) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(Observable[] observables) {
            if (observables == null || observables.length == 0) {
                this.child.onCompleted();
            } else {
                this.started = true;
                this.zipper.start(observables, this.producer);
            }
        }
    }
}

