/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.internal.operators.NotificationLite;
import rx.observables.GroupedObservable;
import rx.subjects.Subject;

public class OperatorGroupBy<T, K, R>
implements Observable.Operator<GroupedObservable<K, R>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends R> valueSelector;
    private static final Func1<Object, Object> IDENTITY = new Func1<Object, Object>(){

        @Override
        public Object call(Object t) {
            return t;
        }
    };

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector) {
        this(keySelector, IDENTITY);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> valueSelector) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, R>> child) {
        return new GroupBySubscriber<K, T, R>(this.keySelector, this.valueSelector, child);
    }

    static final class GroupBySubscriber<K, T, R>
    extends Subscriber<T> {
        private static final int MAX_QUEUE_SIZE = 1024;
        final GroupBySubscriber<K, T, R> self = this;
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends R> elementSelector;
        final Subscriber<? super GroupedObservable<K, R>> child;
        private final ConcurrentHashMap<K, GroupState<K, T>> groups = new ConcurrentHashMap();
        private static final NotificationLite<Object> nl = NotificationLite.instance();
        volatile int completionEmitted;
        volatile int terminated;
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> COMPLETION_EMITTED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "completionEmitted");
        static final AtomicIntegerFieldUpdater<GroupBySubscriber> TERMINATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupBySubscriber.class, "terminated");
        volatile long requested;
        static final AtomicLongFieldUpdater<GroupBySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(GroupBySubscriber.class, "requested");
        volatile long bufferedCount;
        static final AtomicLongFieldUpdater<GroupBySubscriber> BUFFERED_COUNT = AtomicLongFieldUpdater.newUpdater(GroupBySubscriber.class, "bufferedCount");

        public GroupBySubscriber(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> elementSelector, Subscriber<? super GroupedObservable<K, R>> child) {
            this.keySelector = keySelector;
            this.elementSelector = elementSelector;
            this.child = child;
        }

        @Override
        public void onStart() {
            REQUESTED.set(this, 1024L);
            this.request(1024L);
        }

        @Override
        public void onCompleted() {
            if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
                for (GroupState<K, T> group : this.groups.values()) {
                    this.emitItem(group, nl.completed());
                }
                if (this.groups.size() == 0 && COMPLETION_EMITTED_UPDATER.compareAndSet(this, 0, 1)) {
                    this.child.onCompleted();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
                this.child.onError(e);
            }
        }

        void requestFromGroupedObservable(long n, GroupState<K, T> group) {
            ((GroupState)group).requested.getAndAdd(n);
            if (((GroupState)group).count.getAndIncrement() == 0L) {
                this.pollQueue(group);
            }
        }

        @Override
        public void onNext(T t) {
            try {
                K key = this.keySelector.call(t);
                GroupState<K, T> group = this.groups.get(key);
                if (group == null) {
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    group = this.createNewGroup(key);
                }
                this.emitItem(group, nl.next(t));
            }
            catch (Throwable e) {
                this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
            }
        }

        private GroupState<K, T> createNewGroup(final K key) {
            final GroupState groupState = new GroupState();
            GroupedObservable go = GroupedObservable.create(key, new Observable.OnSubscribe<R>(){

                @Override
                public void call(final Subscriber<? super R> o) {
                    o.setProducer(new Producer(){

                        @Override
                        public void request(long n) {
                            GroupBySubscriber.this.requestFromGroupedObservable(n, groupState);
                        }
                    });
                    final AtomicBoolean once = new AtomicBoolean();
                    groupState.getObservable().doOnUnsubscribe(new Action0(){

                        @Override
                        public void call() {
                            if (once.compareAndSet(false, true)) {
                                GroupBySubscriber.this.cleanupGroup(key);
                            }
                        }
                    }).unsafeSubscribe(new Subscriber<T>(o){

                        @Override
                        public void onCompleted() {
                            o.onCompleted();
                            if (once.compareAndSet(false, true)) {
                                GroupBySubscriber.this.cleanupGroup(key);
                            }
                        }

                        @Override
                        public void onError(Throwable e) {
                            o.onError(e);
                        }

                        @Override
                        public void onNext(T t) {
                            try {
                                o.onNext(GroupBySubscriber.this.elementSelector.call(t));
                            }
                            catch (Throwable e) {
                                this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                            }
                        }
                    });
                }
            });
            GroupState putIfAbsent = this.groups.putIfAbsent(key, groupState);
            if (putIfAbsent != null) {
                throw new IllegalStateException("Group already existed while creating a new one");
            }
            this.child.onNext(go);
            return groupState;
        }

        private void cleanupGroup(K key) {
            GroupState<K, T> removed = this.groups.remove(key);
            if (removed != null) {
                if (((GroupState)removed).buffer.size() > 0) {
                    BUFFERED_COUNT.addAndGet(this.self, -((GroupState)removed).buffer.size());
                }
                this.completeInner();
                this.requestMoreIfNecessary();
            }
        }

        private void emitItem(GroupState<K, T> groupState, Object item) {
            Queue q = ((GroupState)groupState).buffer;
            AtomicLong keyRequested = ((GroupState)groupState).requested;
            REQUESTED.decrementAndGet(this);
            if (keyRequested != null && keyRequested.get() > 0L && (q == null || q.isEmpty())) {
                Observer<T> obs = groupState.getObserver();
                nl.accept(obs, item);
                keyRequested.decrementAndGet();
            } else {
                q.add(item);
                BUFFERED_COUNT.incrementAndGet(this);
                if (((GroupState)groupState).count.getAndIncrement() == 0L) {
                    this.pollQueue(groupState);
                }
            }
            this.requestMoreIfNecessary();
        }

        private void pollQueue(GroupState<K, T> groupState) {
            do {
                this.drainIfPossible(groupState);
                long c = ((GroupState)groupState).count.decrementAndGet();
                if (c <= 1L) continue;
                ((GroupState)groupState).count.set(1L);
            } while (((GroupState)groupState).count.get() > 0L);
        }

        private void requestMoreIfNecessary() {
            long toRequest;
            if (REQUESTED.get(this) == 0L && this.terminated == 0 && (toRequest = 1024L - BUFFERED_COUNT.get(this)) > 0L && REQUESTED.compareAndSet(this, 0L, toRequest)) {
                this.request(toRequest);
            }
        }

        private void drainIfPossible(GroupState<K, T> groupState) {
            Object t;
            while (((GroupState)groupState).requested.get() > 0L && (t = ((GroupState)groupState).buffer.poll()) != null) {
                Observer<T> obs = groupState.getObserver();
                nl.accept(obs, t);
                ((GroupState)groupState).requested.decrementAndGet();
                BUFFERED_COUNT.decrementAndGet(this);
                this.requestMoreIfNecessary();
            }
        }

        private void completeInner() {
            if (this.groups.size() == 0 && (this.terminated == 1 || this.child.isUnsubscribed()) && COMPLETION_EMITTED_UPDATER.compareAndSet(this, 0, 1)) {
                if (this.child.isUnsubscribed()) {
                    this.unsubscribe();
                }
                this.child.onCompleted();
            }
        }

        private static class GroupState<K, T> {
            private final Subject<T, T> s = BufferUntilSubscriber.create();
            private final AtomicLong requested = new AtomicLong();
            private final AtomicLong count = new AtomicLong();
            private final Queue<Object> buffer = new ConcurrentLinkedQueue<Object>();

            private GroupState() {
            }

            public Observable<T> getObservable() {
                return this.s;
            }

            public Observer<T> getObserver() {
                return this.s;
            }
        }
    }
}

