/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.producers;

import java.util.ArrayList;
import java.util.List;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;

public final class ProducerObserverArbiter<T>
implements Producer,
Observer<T> {
    final Subscriber<? super T> child;
    boolean emitting;
    List<T> queue;
    Producer currentProducer;
    long requested;
    long missedRequested;
    Producer missedProducer;
    Object missedTerminal;
    volatile boolean hasError;
    static final Producer NULL_PRODUCER = new Producer(){

        @Override
        public void request(long n) {
        }
    };

    public ProducerObserverArbiter(Subscriber<? super T> child) {
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                List<T> q = this.queue;
                if (q == null) {
                    q = new ArrayList<T>(4);
                    this.queue = q;
                }
                q.add(t);
                return;
            }
        }
        boolean skipFinal = false;
        try {
            this.child.onNext(t);
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                this.requested = r - 1L;
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerObserverArbiter producerObserverArbiter2 = this;
                synchronized (producerObserverArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        boolean emit;
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedTerminal = e;
                emit = false;
            } else {
                this.emitting = true;
                emit = true;
            }
        }
        if (emit) {
            this.child.onError(e);
        } else {
            this.hasError = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedTerminal = true;
                return;
            }
            this.emitting = true;
        }
        this.child.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n == 0L) {
            return;
        }
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedRequested += n;
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            long r = this.requested;
            long u = r + n;
            if (u < 0L) {
                u = Long.MAX_VALUE;
            }
            this.requested = u;
            Producer p = this.currentProducer;
            if (p != null) {
                p.request(n);
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerObserverArbiter producerObserverArbiter2 = this;
                synchronized (producerObserverArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer p) {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedProducer = p != null ? p : NULL_PRODUCER;
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            this.currentProducer = p;
            long r = this.requested;
            if (p != null && r != 0L) {
                p.request(r);
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerObserverArbiter producerObserverArbiter2 = this;
                synchronized (producerObserverArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        Subscriber<T> c = this.child;
        block5: while (true) {
            long r;
            boolean empty;
            List<T> q;
            Object localTerminal;
            Producer localProducer;
            long localRequested;
            ProducerObserverArbiter producerObserverArbiter = this;
            synchronized (producerObserverArbiter) {
                localRequested = this.missedRequested;
                localProducer = this.missedProducer;
                localTerminal = this.missedTerminal;
                q = this.queue;
                if (localRequested == 0L && localProducer == null && q == null && localTerminal == null) {
                    this.emitting = false;
                    return;
                }
                this.missedRequested = 0L;
                this.missedProducer = null;
                this.queue = null;
                this.missedTerminal = null;
            }
            boolean bl = empty = q == null || q.isEmpty();
            if (localTerminal != null) {
                if (localTerminal != Boolean.TRUE) {
                    c.onError((Throwable)localTerminal);
                    return;
                }
                if (empty) {
                    c.onCompleted();
                    return;
                }
            }
            long e = 0L;
            if (q != null) {
                for (T v : q) {
                    if (c.isUnsubscribed()) {
                        return;
                    }
                    if (this.hasError) continue block5;
                    try {
                        c.onNext(v);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, c, v);
                        return;
                    }
                }
                e += (long)q.size();
            }
            if ((r = this.requested) != Long.MAX_VALUE) {
                if (localRequested != 0L) {
                    long u = r + localRequested;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    r = u;
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    long u = r - e;
                    if (u < 0L) {
                        throw new IllegalStateException("More produced than requested");
                    }
                    r = u;
                }
                this.requested = r;
            }
            if (localProducer != null) {
                if (localProducer == NULL_PRODUCER) {
                    this.currentProducer = null;
                    continue;
                }
                this.currentProducer = localProducer;
                if (r == 0L) continue;
                localProducer.request(r);
                continue;
            }
            Producer p = this.currentProducer;
            if (p == null || localRequested == 0L) continue;
            p.request(localRequested);
        }
    }
}

