/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorTake<T>
implements Observable.Operator<T, T> {
    final int limit;

    public OperatorTake(int limit) {
        this.limit = limit;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            int count = 0;
            boolean completed = false;

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    child.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.completed) {
                    child.onError(e);
                }
            }

            @Override
            public void onNext(T i) {
                if (!this.isUnsubscribed()) {
                    if (++this.count >= OperatorTake.this.limit) {
                        this.completed = true;
                        this.unsubscribe();
                    }
                    child.onNext(i);
                    if (this.completed) {
                        child.onCompleted();
                    }
                }
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){

                    @Override
                    public void request(long n) {
                        long c = OperatorTake.this.limit - count;
                        if (n < c) {
                            producer.request(n);
                        } else {
                            producer.request(c);
                        }
                    }
                });
            }
        };
        if (this.limit == 0) {
            child.onCompleted();
            parent.unsubscribe();
        }
        child.add(parent);
        return parent;
    }
}

