/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedObserver;
import rx.subjects.Subject;

public class SerializedSubject<T, R>
extends Subject<T, R> {
    private final SerializedObserver<T> observer;

    public SerializedSubject(final Subject<T, R> actual) {
        super(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                actual.unsafeSubscribe(child);
            }
        });
        this.observer = new SerializedObserver(actual);
    }

    @Override
    public void onCompleted() {
        this.observer.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }
}

