/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.Queue;
import rx.Observer;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.NotificationLite;
import rx.internal.util.ObjectPool;
import rx.internal.util.SynchronizedQueue;
import rx.internal.util.unsafe.SpmcArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public class RxRingBuffer
implements Subscription {
    private static final NotificationLite<Object> on = NotificationLite.instance();
    private Queue<Object> queue;
    private final int size;
    private final ObjectPool<Queue<Object>> pool;
    public volatile Object terminalState;
    public static final int SIZE = 1024;
    private static ObjectPool<Queue<Object>> SPSC_POOL = new ObjectPool<Queue<Object>>(){

        @Override
        protected SpscArrayQueue<Object> createObject() {
            return new SpscArrayQueue<Object>(1024);
        }
    };
    private static ObjectPool<Queue<Object>> SPMC_POOL = new ObjectPool<Queue<Object>>(){

        @Override
        protected SpmcArrayQueue<Object> createObject() {
            return new SpmcArrayQueue<Object>(1024);
        }
    };

    public static RxRingBuffer getSpscInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPMC_POOL, 1024);
        }
        return new RxRingBuffer();
    }

    public static RxRingBuffer getSpmcInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPMC_POOL, 1024);
        }
        return new RxRingBuffer();
    }

    private RxRingBuffer(Queue<Object> queue, int size) {
        this.queue = queue;
        this.pool = null;
        this.size = size;
    }

    private RxRingBuffer(ObjectPool<Queue<Object>> pool, int size) {
        this.pool = pool;
        this.queue = pool.borrowObject();
        this.size = size;
    }

    public void release() {
        if (this.pool != null) {
            Queue<Object> q = this.queue;
            q.clear();
            this.queue = null;
            this.pool.returnObject(q);
        }
    }

    @Override
    public void unsubscribe() {
        this.release();
    }

    RxRingBuffer() {
        this(new SynchronizedQueue<Object>(1024), 1024);
    }

    public void onNext(Object o) throws MissingBackpressureException {
        if (this.queue == null) {
            throw new IllegalStateException("This instance has been unsubscribed and the queue is no longer usable.");
        }
        if (!this.queue.offer(on.next(o))) {
            throw new MissingBackpressureException();
        }
    }

    public void onCompleted() {
        if (this.terminalState == null) {
            this.terminalState = on.completed();
        }
    }

    public void onError(Throwable t) {
        if (this.terminalState == null) {
            this.terminalState = on.error(t);
        }
    }

    public int available() {
        return this.size - this.count();
    }

    public int capacity() {
        return this.size;
    }

    public int count() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.size();
    }

    public boolean isEmpty() {
        if (this.queue == null) {
            return true;
        }
        return this.queue.isEmpty();
    }

    public Object poll() {
        if (this.queue == null) {
            return null;
        }
        Object o = this.queue.poll();
        if (o == null && this.terminalState != null && this.queue.isEmpty()) {
            o = this.terminalState;
            this.terminalState = null;
        }
        return o;
    }

    public Object peek() {
        if (this.queue == null) {
            return null;
        }
        Object o = this.queue.peek();
        if (o == null && this.terminalState != null && this.queue.isEmpty()) {
            o = this.terminalState;
        }
        return o;
    }

    public boolean isCompleted(Object o) {
        return on.isCompleted(o);
    }

    public boolean isError(Object o) {
        return on.isError(o);
    }

    public Object getValue(Object o) {
        return on.getValue(o);
    }

    public boolean accept(Object o, Observer child) {
        return on.accept(child, o);
    }

    public Throwable asError(Object o) {
        return on.getError(o);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.queue == null;
    }
}

