/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Functions;

public final class OperatorSequenceEqual {
    private static final Object LOCAL_ONCOMPLETED = new Object();

    private OperatorSequenceEqual() {
        throw new IllegalStateException("No instances!");
    }

    static <T> Observable<Object> materializeLite(Observable<T> source) {
        return Observable.concat(source.map(new Func1<T, Object>(){

            @Override
            public Object call(T t1) {
                return t1;
            }
        }), Observable.just(LOCAL_ONCOMPLETED));
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second, final Func2<? super T, ? super T, Boolean> equality) {
        Observable<Object> firstObservable = OperatorSequenceEqual.materializeLite(first);
        Observable<Object> secondObservable = OperatorSequenceEqual.materializeLite(second);
        return Observable.zip(firstObservable, secondObservable, new Func2<Object, Object, Boolean>(){

            @Override
            public Boolean call(Object t1, Object t2) {
                boolean c2;
                boolean c1 = t1 == LOCAL_ONCOMPLETED;
                boolean bl = c2 = t2 == LOCAL_ONCOMPLETED;
                if (c1 && c2) {
                    return true;
                }
                if (c1 || c2) {
                    return false;
                }
                return (Boolean)equality.call(t1, t2);
            }
        }).all(Functions.identity());
    }
}

