/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.MissingBackpressureException;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.ScalarSynchronousObservable;
import rx.internal.util.SubscriptionIndexedRingBuffer;

public class OperatorMerge<T>
implements Observable.Operator<T, Observable<? extends T>> {
    private final boolean delayErrors;

    public OperatorMerge() {
        this.delayErrors = false;
    }

    public OperatorMerge(boolean delayErrors) {
        this.delayErrors = delayErrors;
    }

    @Override
    public Subscriber<Observable<? extends T>> call(Subscriber<? super T> child) {
        return new MergeSubscriber<T>(child, this.delayErrors);
    }

    private static final class InnerSubscriber<T>
    extends Subscriber<T> {
        public int sindex;
        final MergeSubscriber<T> parentSubscriber;
        final MergeProducer<T> producer;
        volatile int terminated;
        static final AtomicIntegerFieldUpdater<InnerSubscriber> ONCE_TERMINATED = AtomicIntegerFieldUpdater.newUpdater(InnerSubscriber.class, "terminated");
        private final RxRingBuffer q = RxRingBuffer.getSpmcInstance();
        int emitted = 0;
        final int THRESHOLD = (int)((double)this.q.capacity() * 0.7);

        public InnerSubscriber(MergeSubscriber<T> parent, MergeProducer<T> producer) {
            this.parentSubscriber = parent;
            this.producer = producer;
            this.add(this.q);
            this.request(this.q.capacity());
        }

        @Override
        public void onNext(T t) {
            this.emit(t, false);
        }

        @Override
        public void onError(Throwable e) {
            if (ONCE_TERMINATED.compareAndSet(this, 0, 1)) {
                this.parentSubscriber.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            if (ONCE_TERMINATED.compareAndSet(this, 0, 1)) {
                this.emit(null, true);
            }
        }

        public void requestMore(long n) {
            this.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emit(T t, boolean complete) {
            boolean drain = false;
            boolean enqueue = true;
            if (((MergeSubscriber)this.parentSubscriber).getEmitLock()) {
                block15: {
                    enqueue = false;
                    try {
                        this.emitted += this.drainQueue();
                        if (this.producer == null) {
                            if (complete) {
                                this.parentSubscriber.completeInner(this);
                                break block15;
                            }
                            try {
                                this.parentSubscriber.actual.onNext(t);
                            }
                            catch (Throwable e) {
                                this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                            }
                            ++this.emitted;
                            break block15;
                        }
                        if (((MergeProducer)this.producer).requested > 0L && this.q.count() == 0) {
                            if (complete) {
                                this.parentSubscriber.completeInner(this);
                                break block15;
                            }
                            try {
                                this.parentSubscriber.actual.onNext(t);
                            }
                            catch (Throwable e) {
                                this.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                            }
                            ++this.emitted;
                            MergeProducer.REQUESTED.decrementAndGet(this.producer);
                            break block15;
                        }
                        enqueue = true;
                    }
                    finally {
                        drain = ((MergeSubscriber)this.parentSubscriber).releaseEmitLock();
                    }
                }
                if (this.emitted > this.THRESHOLD) {
                    this.request(this.emitted);
                    this.emitted = 0;
                }
            }
            if (enqueue) {
                this.enqueue(t, complete);
                drain = true;
            }
            if (drain) {
                ((MergeSubscriber)this.parentSubscriber).drainQueuesIfNeeded();
            }
        }

        private void enqueue(T t, boolean complete) {
            try {
                if (complete) {
                    this.q.onCompleted();
                } else {
                    this.q.onNext(t);
                }
            }
            catch (MissingBackpressureException e) {
                this.onError(e);
            }
        }

        private int drainRequested() {
            Object o;
            int emitted = 0;
            long toEmit = ((MergeProducer)this.producer).requested;
            int i = 0;
            while ((long)i < toEmit && (o = this.q.poll()) != null) {
                if (this.q.isCompleted(o)) {
                    this.parentSubscriber.completeInner(this);
                } else {
                    try {
                        if (!this.q.accept(o, this.parentSubscriber.actual)) {
                            ++emitted;
                        }
                    }
                    catch (Throwable e) {
                        this.onError(OnErrorThrowable.addValueAsLastCause(e, o));
                    }
                }
                ++i;
            }
            MergeProducer.REQUESTED.getAndAdd(this.producer, -emitted);
            return emitted;
        }

        private int drainAll() {
            Object o;
            int emitted = 0;
            while ((o = this.q.poll()) != null) {
                if (this.q.isCompleted(o)) {
                    this.parentSubscriber.completeInner(this);
                    continue;
                }
                try {
                    if (this.q.accept(o, this.parentSubscriber.actual)) continue;
                    ++emitted;
                }
                catch (Throwable e) {
                    this.onError(OnErrorThrowable.addValueAsLastCause(e, o));
                }
            }
            return emitted;
        }

        private int drainQueue() {
            if (this.producer != null) {
                return this.drainRequested();
            }
            return this.drainAll();
        }
    }

    private static final class MergeProducer<T>
    implements Producer {
        private final MergeSubscriber<T> ms;
        private volatile long requested = 0L;
        static final AtomicLongFieldUpdater<MergeProducer> REQUESTED = AtomicLongFieldUpdater.newUpdater(MergeProducer.class, "requested");

        public MergeProducer(MergeSubscriber<T> ms) {
            this.ms = ms;
        }

        @Override
        public void request(long n) {
            if (this.requested == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE) {
                this.requested = Long.MAX_VALUE;
            } else {
                REQUESTED.getAndAdd(this, n);
                ((MergeSubscriber)this.ms).drainQueuesIfNeeded();
            }
        }
    }

    private static final class MergeSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final NotificationLite<T> on = NotificationLite.instance();
        final Subscriber<? super T> actual;
        private final MergeProducer<T> mergeProducer;
        private int wip;
        private boolean completed;
        private final boolean delayErrors;
        private ConcurrentLinkedQueue<Throwable> exceptions;
        private volatile SubscriptionIndexedRingBuffer<InnerSubscriber<T>> childrenSubscribers;
        private RxRingBuffer scalarValueQueue = null;
        private int missedEmitting = 0;
        private boolean emitLock = false;
        int lastDrainedIndex = 0;
        final Func1<InnerSubscriber<T>, Boolean> DRAIN_ACTION = new Func1<InnerSubscriber<T>, Boolean>(){

            @Override
            public Boolean call(InnerSubscriber<T> s) {
                if (s.q != null) {
                    long r = MergeSubscriber.this.mergeProducer.requested;
                    int emitted = 0;
                    if ((emitted += s.drainQueue()) > 0) {
                        s.emitted = 0;
                        s.requestMore(emitted += s.emitted);
                    }
                    if ((long)emitted == r) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }
        };

        public MergeSubscriber(Subscriber<? super T> actual, boolean delayErrors) {
            super(actual);
            this.actual = actual;
            this.mergeProducer = new MergeProducer(this);
            this.delayErrors = delayErrors;
            actual.add(this);
            actual.setProducer(this.mergeProducer);
        }

        @Override
        public void onStart() {
            this.request(1024L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            if (t instanceof ScalarSynchronousObservable) {
                this.handleScalarSynchronousObservable((ScalarSynchronousObservable)t);
            } else {
                if (t == null || this.isUnsubscribed()) {
                    return;
                }
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    ++this.wip;
                }
                this.handleNewSource(t);
            }
        }

        private void handleNewSource(Observable<? extends T> t) {
            if (this.childrenSubscribers == null) {
                this.childrenSubscribers = new SubscriptionIndexedRingBuffer();
                this.add(this.childrenSubscribers);
            }
            MergeProducer<T> producerIfNeeded = null;
            if (((MergeProducer)this.mergeProducer).requested != Long.MAX_VALUE) {
                producerIfNeeded = this.mergeProducer;
            }
            InnerSubscriber<T> i = new InnerSubscriber<T>(this, producerIfNeeded);
            i.sindex = this.childrenSubscribers.add(i);
            t.unsafeSubscribe(i);
            this.request(1L);
        }

        private void handleScalarSynchronousObservable(ScalarSynchronousObservable<? extends T> t) {
            if (((MergeProducer)this.mergeProducer).requested == Long.MAX_VALUE) {
                this.handleScalarSynchronousObservableWithoutRequestLimits(t);
            } else {
                this.handleScalarSynchronousObservableWithRequestLimits(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleScalarSynchronousObservableWithoutRequestLimits(ScalarSynchronousObservable<? extends T> t) {
            T value = t.get();
            if (this.getEmitLock()) {
                try {
                    this.actual.onNext(value);
                    return;
                }
                finally {
                    if (this.releaseEmitLock()) {
                        this.drainQueuesIfNeeded();
                    }
                    this.request(1L);
                }
            }
            this.initScalarValueQueueIfNeeded();
            try {
                this.scalarValueQueue.onNext(value);
            }
            catch (MissingBackpressureException e) {
                this.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleScalarSynchronousObservableWithRequestLimits(ScalarSynchronousObservable<? extends T> t) {
            if (this.getEmitLock()) {
                boolean emitted = false;
                try {
                    long r = ((MergeProducer)this.mergeProducer).requested;
                    if (r > 0L) {
                        emitted = true;
                        this.actual.onNext(t.get());
                        MergeProducer.REQUESTED.decrementAndGet(this.mergeProducer);
                        return;
                    }
                }
                finally {
                    if (this.releaseEmitLock()) {
                        this.drainQueuesIfNeeded();
                    }
                    if (emitted) {
                        this.request(1L);
                    }
                }
            }
            this.initScalarValueQueueIfNeeded();
            try {
                this.scalarValueQueue.onNext(t.get());
            }
            catch (MissingBackpressureException e) {
                this.onError(e);
            }
        }

        private void initScalarValueQueueIfNeeded() {
            if (this.scalarValueQueue == null) {
                this.scalarValueQueue = RxRingBuffer.getSpmcInstance();
                this.add(this.scalarValueQueue);
            }
        }

        private synchronized boolean releaseEmitLock() {
            this.emitLock = false;
            return this.missedEmitting != 0;
        }

        private synchronized boolean getEmitLock() {
            if (this.emitLock) {
                ++this.missedEmitting;
                return false;
            }
            this.emitLock = true;
            this.missedEmitting = 0;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drainQueuesIfNeeded() {
            while (this.getEmitLock()) {
                int emitted = 0;
                try {
                    emitted = this.drainScalarValueQueue();
                    this.drainChildrenQueues();
                }
                finally {
                    boolean moreToDrain = this.releaseEmitLock();
                    this.request(emitted);
                    if (moreToDrain) continue;
                    return true;
                }
            }
            return false;
        }

        private void drainChildrenQueues() {
            if (this.childrenSubscribers != null) {
                this.lastDrainedIndex = this.childrenSubscribers.forEach(this.DRAIN_ACTION, this.lastDrainedIndex);
            }
        }

        private int drainScalarValueQueue() {
            if (this.scalarValueQueue != null) {
                long r = ((MergeProducer)this.mergeProducer).requested;
                int emittedWhileDraining = 0;
                if (r < 0L) {
                    Object o = null;
                    while ((o = this.scalarValueQueue.poll()) != null) {
                        this.on.accept(this.actual, o);
                        ++emittedWhileDraining;
                    }
                } else if (r > 0L) {
                    Object o;
                    long toEmit = r;
                    int i = 0;
                    while ((long)i < toEmit && (o = this.scalarValueQueue.poll()) != null) {
                        this.on.accept(this.actual, o);
                        ++emittedWhileDraining;
                        ++i;
                    }
                    MergeProducer.REQUESTED.getAndAdd(this.mergeProducer, -emittedWhileDraining);
                }
                return emittedWhileDraining;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (this.delayErrors) {
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    if (this.exceptions == null) {
                        this.exceptions = new ConcurrentLinkedQueue();
                    }
                }
                this.exceptions.add(e);
                boolean sendOnComplete = false;
                MergeSubscriber mergeSubscriber2 = this;
                synchronized (mergeSubscriber2) {
                    --this.wip;
                    if (this.wip == 0 && this.completed || this.wip < 0) {
                        sendOnComplete = true;
                    }
                }
                if (sendOnComplete) {
                    this.drainAndComplete();
                }
            } else {
                this.actual.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            boolean c = false;
            MergeSubscriber mergeSubscriber = this;
            synchronized (mergeSubscriber) {
                this.completed = true;
                if (this.wip == 0) {
                    c = true;
                }
            }
            if (c) {
                this.drainAndComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completeInner(InnerSubscriber<T> s) {
            boolean sendOnComplete = false;
            MergeSubscriber mergeSubscriber = this;
            synchronized (mergeSubscriber) {
                --this.wip;
                if (this.wip == 0 && this.completed) {
                    sendOnComplete = true;
                }
            }
            this.childrenSubscribers.remove(s.sindex);
            if (sendOnComplete) {
                this.drainAndComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drainAndComplete() {
            this.drainQueuesIfNeeded();
            if (this.delayErrors) {
                ConcurrentLinkedQueue<Throwable> es = null;
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    es = this.exceptions;
                }
                if (es != null) {
                    if (es.isEmpty()) {
                        this.actual.onCompleted();
                    } else if (es.size() == 1) {
                        this.actual.onError((Throwable)es.poll());
                    } else {
                        this.actual.onError(new CompositeException(es));
                    }
                } else {
                    this.actual.onCompleted();
                }
            } else {
                this.actual.onCompleted();
            }
        }
    }
}

