/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Observable;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> BehaviorSubject<T> create() {
        return BehaviorSubject.create(null, false);
    }

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        return BehaviorSubject.create(defaultValue, true);
    }

    private static <T> BehaviorSubject<T> create(T defaultValue, boolean hasDefault) {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        if (hasDefault) {
            state.set(NotificationLite.instance().next(defaultValue));
        }
        state.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.get(), state.nl);
            }
        };
        state.onTerminated = state.onAdded;
        return new BehaviorSubject(state, state);
    }

    protected BehaviorSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.completed();
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.error(e);
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onNext(T v) {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.next(v);
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.next(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    int subscriberCount() {
        return this.state.observers().length;
    }
}

