/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnExceptionResumeNextViaObservable<T>
implements Observable.Operator<T, T> {
    final Observable<? extends T> resumeSequence;

    public OperatorOnExceptionResumeNextViaObservable(Observable<? extends T> resumeSequence) {
        this.resumeSequence = resumeSequence;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber s = new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                if (e instanceof Exception) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    this.unsubscribe();
                    OperatorOnExceptionResumeNextViaObservable.this.resumeSequence.unsafeSubscribe(child);
                } else {
                    child.onError(e);
                }
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
        child.add(s);
        return s;
    }
}

