/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.unsafe;

import rx.internal.util.unsafe.SpmcArrayQueueL3Pad;

public final class SpmcArrayQueue<E>
extends SpmcArrayQueueL3Pad<E> {
    public SpmcArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] lb = this.buffer;
        long currProducerIndex = this.lvProducerIndex();
        long offset = this.calcElementOffset(currProducerIndex);
        if (null != this.lvElement(lb, offset)) {
            int size = (int)(currProducerIndex - this.lvConsumerIndex());
            if (size == this.capacity) {
                return false;
            }
            while (null != this.lvElement(lb, offset)) {
            }
        }
        this.spElement(lb, offset, e);
        this.soTail(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casHead(currentConsumerIndex, currentConsumerIndex + 1L));
        long offset = this.calcElementOffset(currentConsumerIndex);
        Object[] lb = this.buffer;
        Object e = this.lpElement(lb, offset);
        this.soElement(lb, offset, null);
        return (E)e;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.lvConsumerIndex()));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }
}

