/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorParallel<T, R>
implements Observable.Operator<R, T> {
    private final Scheduler scheduler;
    private final Func1<Observable<T>, Observable<R>> f;
    private final int degreeOfParallelism;

    public OperatorParallel(Func1<Observable<T>, Observable<R>> f, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.f = f;
        this.degreeOfParallelism = scheduler.parallelism();
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> child) {
        Observable[] os = new Observable[this.degreeOfParallelism];
        final Subscriber[] ss = new Subscriber[this.degreeOfParallelism];
        final ParentSubscriber subscriber = new ParentSubscriber(child, ss);
        for (int i = 0; i < os.length; ++i) {
            final int index = i;
            Observable o = Observable.create(new Observable.OnSubscribe<T>(){

                @Override
                public void call(Subscriber<? super T> inner) {
                    ss[index] = inner;
                    child.add(inner);
                    inner.setProducer(new Producer(){

                        @Override
                        public void request(long n) {
                            subscriber.requestMore(n);
                        }
                    });
                }
            });
            os[i] = this.f.call(o.observeOn(this.scheduler));
        }
        Observable.merge(os).unsafeSubscribe(child);
        return subscriber;
    }

    private class ParentSubscriber
    extends Subscriber<T> {
        final Subscriber<? super R> child;
        final Subscriber<? super T>[] ss;
        int index;
        final AtomicLong initialRequest;
        final AtomicBoolean started;

        private ParentSubscriber(Subscriber<? super R> child, Subscriber<? super T>[] ss) {
            super(child);
            this.index = 0;
            this.initialRequest = new AtomicLong();
            this.started = new AtomicBoolean();
            this.child = child;
            this.ss = ss;
        }

        public void requestMore(long n) {
            if (this.started.get()) {
                this.request(n);
            } else {
                this.initialRequest.addAndGet(n);
            }
        }

        @Override
        public void onStart() {
            if (this.started.compareAndSet(false, true)) {
                this.request(this.initialRequest.get());
            }
        }

        @Override
        public void onCompleted() {
            for (Subscriber subscriber : this.ss) {
                subscriber.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.ss[this.index++].onNext(t);
            if (this.index >= OperatorParallel.this.degreeOfParallelism) {
                this.index = 0;
            }
        }
    }
}

