/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import rx.Notification;
import rx.functions.Action0;
import rx.functions.Action2;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver1;

public final class ActivePlan2<T1, T2>
extends ActivePlan0 {
    private final Action2<T1, T2> onNext;
    private final Action0 onCompleted;
    private final JoinObserver1<T1> jo1;
    private final JoinObserver1<T2> jo2;

    ActivePlan2(JoinObserver1<T1> jo1, JoinObserver1<T2> jo2, Action2<T1, T2> onNext, Action0 onCompleted) {
        this.onNext = onNext;
        this.onCompleted = onCompleted;
        this.jo1 = jo1;
        this.jo2 = jo2;
        this.addJoinObserver(jo1);
        this.addJoinObserver(jo2);
    }

    @Override
    protected void match() {
        if (!this.jo1.queue().isEmpty() && !this.jo2.queue().isEmpty()) {
            Notification<T1> n1 = this.jo1.queue().peek();
            Notification<T2> n2 = this.jo2.queue().peek();
            if (n1.isOnCompleted() || n2.isOnCompleted()) {
                this.onCompleted.call();
            } else {
                this.dequeue();
                this.onNext.call(n1.getValue(), n2.getValue());
            }
        }
    }
}

