/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import rx.Subscriber;
import rx.plugins.DebugNotification;
import rx.plugins.DebugNotificationListener;
import rx.plugins.SimpleContext;

public class SimpleDebugNotificationListener
extends DebugNotificationListener<SimpleContext<?>> {
    private final Map<Subscriber<?>, Queue<SimpleContext<?>>> notificationsByObservable = new ConcurrentHashMap();

    @Override
    public <T> SimpleContext<?> start(DebugNotification<T> n) {
        SimpleContext<T> context = new SimpleContext<T>(n);
        Queue<SimpleContext<?>> notifications = this.notificationsByObservable.get(n.getObserver());
        if (notifications == null) {
            notifications = new LinkedBlockingQueue();
            this.notificationsByObservable.put((Subscriber)n.getObserver(), notifications);
        }
        notifications.add(context);
        return context;
    }

    @Override
    public void complete(SimpleContext<?> context) {
        context.setEnd();
    }

    @Override
    public void error(SimpleContext<?> context, Throwable e) {
        context.setError(e);
    }

    public String toString() {
        SortedSet<NotificationsByObservable<?>> notificationsByObservableSnapshot = this.getNotificationsByObservable();
        return this.toString(notificationsByObservableSnapshot);
    }

    public String toString(SortedSet<NotificationsByObservable<?>> notificationsByObservableSnapshot) {
        StringBuilder str = new StringBuilder();
        str.append("{\n  ");
        boolean first = true;
        for (NotificationsByObservable notificationsByObservable : notificationsByObservableSnapshot) {
            if (!first) {
                str.append(",\n  ");
            }
            notificationsByObservable.append(str);
            first = false;
        }
        str.append("\n}");
        return str.toString();
    }

    public SortedSet<NotificationsByObservable<?>> getNotificationsByObservable() {
        TreeSet notificationsByObservableSnapshot = new TreeSet();
        for (Map.Entry entry : this.notificationsByObservable.entrySet()) {
            notificationsByObservableSnapshot.add(new NotificationsByObservable(entry));
        }
        return notificationsByObservableSnapshot;
    }

    public static class NotificationsByObservable<T>
    implements Comparable<NotificationsByObservable<T>> {
        public final Subscriber<T> subscriber;
        public final SortedSet<SimpleContext<T>> notifications;

        public NotificationsByObservable(Map.Entry<Subscriber<T>, Queue<SimpleContext<T>>> context) {
            this.subscriber = context.getKey();
            this.notifications = new TreeSet<SimpleContext<T>>();
            this.notifications.addAll((Collection)context.getValue());
        }

        @Override
        public int compareTo(NotificationsByObservable<T> o) {
            if (this.notifications.isEmpty()) {
                return o.notifications.isEmpty() ? 0 : -1;
            }
            if (o.notifications.isEmpty()) {
                return 1;
            }
            return this.notifications.first().compareTo(o.notifications.first());
        }

        public void append(StringBuilder str) {
            str.append("\"").append(this.subscriber.toString()).append("\": [\n    ");
            boolean first = true;
            for (SimpleContext simpleContext : this.notifications) {
                if (!first) {
                    str.append(",\n    ");
                }
                str.append(simpleContext.toString());
                first = false;
            }
            str.append("\n  ]");
        }

        public SortedSet<SimpleContext<T>> getNotifications() {
            return this.notifications;
        }
    }
}

