/*
 * Decompiled with CFR 0.152.
 */
package rx.android.schedulers;

import android.os.Looper;
import rx.Scheduler;
import rx.android.plugins.RxAndroidPlugins;
import rx.android.plugins.RxAndroidSchedulersHook;
import rx.android.schedulers.LooperScheduler;

public final class AndroidSchedulers {
    private static final AndroidSchedulers INSTANCE = new AndroidSchedulers();
    private final Scheduler mainThreadScheduler;

    private AndroidSchedulers() {
        RxAndroidSchedulersHook hook = RxAndroidPlugins.getInstance().getSchedulersHook();
        Scheduler main = hook.getMainThreadScheduler();
        this.mainThreadScheduler = main != null ? main : new LooperScheduler(Looper.getMainLooper());
    }

    public static Scheduler mainThread() {
        return AndroidSchedulers.INSTANCE.mainThreadScheduler;
    }

    public static Scheduler from(Looper looper) {
        if (looper == null) {
            throw new NullPointerException("looper == null");
        }
        return new LooperScheduler(looper);
    }
}

