/*
 * Decompiled with CFR 0.152.
 */
package rx.android.operators;

import android.view.View;
import android.widget.CompoundButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.events.OnCheckedChangeEvent;
import rx.android.observables.Assertions;
import rx.android.subscriptions.AndroidSubscriptions;
import rx.functions.Action0;

public class OperatorCompoundButtonInput
implements Observable.OnSubscribe<OnCheckedChangeEvent> {
    private final boolean emitInitialValue;
    private final CompoundButton button;

    public OperatorCompoundButtonInput(CompoundButton button, boolean emitInitialValue) {
        this.emitInitialValue = emitInitialValue;
        this.button = button;
    }

    public void call(final Subscriber<? super OnCheckedChangeEvent> observer) {
        Assertions.assertUiThread();
        final CompositeOnCheckedChangeListener composite = CachedListeners.getFromViewOrCreate(this.button);
        final CompoundButton.OnCheckedChangeListener listener = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton view, boolean checked) {
                observer.onNext((Object)new OnCheckedChangeEvent(OperatorCompoundButtonInput.this.button, checked));
            }
        };
        Subscription subscription = AndroidSubscriptions.unsubscribeInUiThread(new Action0(){

            public void call() {
                composite.removeOnCheckedChangeListener(listener);
            }
        });
        if (this.emitInitialValue) {
            observer.onNext((Object)new OnCheckedChangeEvent(this.button));
        }
        composite.addOnCheckedChangeListener(listener);
        observer.add(subscription);
    }

    private static class CachedListeners {
        private static final Map<View, CompositeOnCheckedChangeListener> sCachedListeners = new WeakHashMap<View, CompositeOnCheckedChangeListener>();

        private CachedListeners() {
        }

        public static CompositeOnCheckedChangeListener getFromViewOrCreate(CompoundButton button) {
            CompositeOnCheckedChangeListener cached = sCachedListeners.get(button);
            if (cached != null) {
                return cached;
            }
            CompositeOnCheckedChangeListener listener = new CompositeOnCheckedChangeListener();
            sCachedListeners.put((View)button, listener);
            button.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)listener);
            return listener;
        }
    }

    private static class CompositeOnCheckedChangeListener
    implements CompoundButton.OnCheckedChangeListener {
        private final List<CompoundButton.OnCheckedChangeListener> listeners = new ArrayList<CompoundButton.OnCheckedChangeListener>();

        private CompositeOnCheckedChangeListener() {
        }

        public boolean addOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
            return this.listeners.add(listener);
        }

        public boolean removeOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
            return this.listeners.remove(listener);
        }

        public void onCheckedChanged(CompoundButton button, boolean checked) {
            for (CompoundButton.OnCheckedChangeListener listener : this.listeners) {
                listener.onCheckedChanged(button, checked);
            }
        }
    }
}

