/*
 * Decompiled with CFR 0.152.
 */
package rx.android.operators;

import android.view.View;
import android.widget.AdapterView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.events.OnItemClickEvent;
import rx.android.observables.Assertions;
import rx.android.subscriptions.AndroidSubscriptions;
import rx.functions.Action0;

public class OperatorAdapterViewOnItemClick
implements Observable.OnSubscribe<OnItemClickEvent> {
    private final AdapterView<?> adapterView;

    public OperatorAdapterViewOnItemClick(AdapterView<?> adapterView) {
        this.adapterView = adapterView;
    }

    public void call(final Subscriber<? super OnItemClickEvent> observer) {
        Assertions.assertUiThread();
        final CompositeOnClickListener composite = CachedListeners.getFromViewOrCreate(this.adapterView);
        final AdapterView.OnItemClickListener listener = new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                observer.onNext((Object)new OnItemClickEvent(parent, view, position, id));
            }
        };
        Subscription subscription = AndroidSubscriptions.unsubscribeInUiThread(new Action0(){

            public void call() {
                composite.removeOnClickListener(listener);
            }
        });
        composite.addOnClickListener(listener);
        observer.add(subscription);
    }

    private static class CachedListeners {
        private static final Map<AdapterView<?>, CompositeOnClickListener> sCachedListeners = new WeakHashMap();

        private CachedListeners() {
        }

        public static CompositeOnClickListener getFromViewOrCreate(AdapterView<?> view) {
            CompositeOnClickListener cached = sCachedListeners.get(view);
            if (cached != null) {
                return cached;
            }
            CompositeOnClickListener listener = new CompositeOnClickListener();
            sCachedListeners.put(view, listener);
            view.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
            return listener;
        }
    }

    private static class CompositeOnClickListener
    implements AdapterView.OnItemClickListener {
        private final List<AdapterView.OnItemClickListener> listeners = new ArrayList<AdapterView.OnItemClickListener>();

        private CompositeOnClickListener() {
        }

        public boolean addOnClickListener(AdapterView.OnItemClickListener listener) {
            return this.listeners.add(listener);
        }

        public boolean removeOnClickListener(AdapterView.OnItemClickListener listener) {
            return this.listeners.remove(listener);
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            for (AdapterView.OnItemClickListener listener : this.listeners) {
                listener.onItemClick(parent, view, position, id);
            }
        }
    }
}

