/*
 * Decompiled with CFR 0.152.
 */
package rx.android.operators;

import android.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.events.OnClickEvent;
import rx.android.observables.Assertions;
import rx.android.subscriptions.AndroidSubscriptions;
import rx.functions.Action0;

public final class OperatorViewClick
implements Observable.OnSubscribe<OnClickEvent> {
    private final boolean emitInitialValue;
    private final View view;

    public OperatorViewClick(View view, boolean emitInitialValue) {
        this.emitInitialValue = emitInitialValue;
        this.view = view;
    }

    public void call(final Subscriber<? super OnClickEvent> observer) {
        Assertions.assertUiThread();
        final CompositeOnClickListener composite = CachedListeners.getFromViewOrCreate(this.view);
        final View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View clicked) {
                observer.onNext((Object)new OnClickEvent(OperatorViewClick.this.view));
            }
        };
        Subscription subscription = AndroidSubscriptions.unsubscribeInUiThread(new Action0(){

            public void call() {
                composite.removeOnClickListener(listener);
            }
        });
        if (this.emitInitialValue) {
            observer.onNext((Object)new OnClickEvent(this.view));
        }
        composite.addOnClickListener(listener);
        observer.add(subscription);
    }

    private static class CachedListeners {
        private static final Map<View, CompositeOnClickListener> sCachedListeners = new WeakHashMap<View, CompositeOnClickListener>();

        private CachedListeners() {
        }

        public static CompositeOnClickListener getFromViewOrCreate(View view) {
            CompositeOnClickListener cached = sCachedListeners.get(view);
            if (cached != null) {
                return cached;
            }
            CompositeOnClickListener listener = new CompositeOnClickListener();
            sCachedListeners.put(view, listener);
            view.setOnClickListener((View.OnClickListener)listener);
            return listener;
        }
    }

    private static class CompositeOnClickListener
    implements View.OnClickListener {
        private final List<View.OnClickListener> listeners = new ArrayList<View.OnClickListener>();

        private CompositeOnClickListener() {
        }

        public boolean addOnClickListener(View.OnClickListener listener) {
            return this.listeners.add(listener);
        }

        public boolean removeOnClickListener(View.OnClickListener listener) {
            return this.listeners.remove(listener);
        }

        public void onClick(View view) {
            for (View.OnClickListener listener : this.listeners) {
                listener.onClick(view);
            }
        }
    }
}

