/*
 * Decompiled with CFR 0.152.
 */
package rx.android.operators;

import android.util.Log;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Functions;

public final class OperatorConditionalBinding<T, R>
implements Observable.Operator<T, T> {
    private static final String LOG_TAG = "ConditionalBinding";
    private R boundRef;
    private final Func1<? super R, Boolean> predicate;

    public OperatorConditionalBinding(R bound, Func1<? super R, Boolean> predicate) {
        this.boundRef = bound;
        this.predicate = predicate;
    }

    public OperatorConditionalBinding(R bound) {
        this.boundRef = bound;
        this.predicate = Functions.alwaysTrue();
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            public void onCompleted() {
                if (this.shouldForwardNotification()) {
                    child.onCompleted();
                } else {
                    this.handleLostBinding("onCompleted");
                }
            }

            public void onError(Throwable e) {
                if (this.shouldForwardNotification()) {
                    child.onError(e);
                } else {
                    this.handleLostBinding("onError");
                }
            }

            public void onNext(T t) {
                if (this.shouldForwardNotification()) {
                    child.onNext(t);
                } else {
                    this.handleLostBinding("onNext");
                }
            }

            private boolean shouldForwardNotification() {
                return OperatorConditionalBinding.this.boundRef != null && (Boolean)OperatorConditionalBinding.this.predicate.call(OperatorConditionalBinding.this.boundRef) != false;
            }

            private void handleLostBinding(String context) {
                this.log("bound object has become invalid; skipping " + context);
                this.log("unsubscribing...");
                OperatorConditionalBinding.this.boundRef = null;
                this.unsubscribe();
            }

            private void log(String message) {
                if (Log.isLoggable((String)OperatorConditionalBinding.LOG_TAG, (int)3)) {
                    Log.d((String)OperatorConditionalBinding.LOG_TAG, (String)message);
                }
            }
        };
    }

    R getBoundRef() {
        return this.boundRef;
    }
}

