/*
 * Decompiled with CFR 0.152.
 */
package rx.android.observables;

import android.view.View;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.TextView;
import rx.Observable;
import rx.android.events.OnCheckedChangeEvent;
import rx.android.events.OnClickEvent;
import rx.android.events.OnItemClickEvent;
import rx.android.events.OnTextChangeEvent;
import rx.android.operators.OperatorAdapterViewOnItemClick;
import rx.android.operators.OperatorCompoundButtonInput;
import rx.android.operators.OperatorTextViewInput;
import rx.android.operators.OperatorViewClick;

public class ViewObservable {
    public static Observable<OnClickEvent> clicks(View view) {
        return ViewObservable.clicks(view, false);
    }

    public static Observable<OnClickEvent> clicks(View view, boolean emitInitialValue) {
        return Observable.create((Observable.OnSubscribe)new OperatorViewClick(view, emitInitialValue));
    }

    public static Observable<OnTextChangeEvent> text(TextView input) {
        return ViewObservable.text(input, false);
    }

    public static Observable<OnTextChangeEvent> text(TextView input, boolean emitInitialValue) {
        return Observable.create((Observable.OnSubscribe)new OperatorTextViewInput(input, emitInitialValue));
    }

    public static Observable<OnCheckedChangeEvent> input(CompoundButton button) {
        return ViewObservable.input(button, false);
    }

    public static Observable<OnCheckedChangeEvent> input(CompoundButton button, boolean emitInitialValue) {
        return Observable.create((Observable.OnSubscribe)new OperatorCompoundButtonInput(button, emitInitialValue));
    }

    public static Observable<OnItemClickEvent> itemClicks(AdapterView<?> adapterView) {
        return Observable.create((Observable.OnSubscribe)new OperatorAdapterViewOnItemClick(adapterView));
    }
}

