/*
 * Decompiled with CFR 0.152.
 */
package rx.android.observables;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import rx.Observable;
import rx.android.observables.Assertions;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.operators.OperatorBroadcastRegister;
import rx.operators.OperatorConditionalBinding;
import rx.operators.OperatorLocalBroadcastRegister;

public final class AndroidObservable {
    private static final boolean USES_SUPPORT_FRAGMENTS;
    private static final Func1<Activity, Boolean> ACTIVITY_VALIDATOR;
    private static final Func1<Fragment, Boolean> FRAGMENT_VALIDATOR;
    private static final Func1<android.support.v4.app.Fragment, Boolean> FRAGMENTV4_VALIDATOR;

    private AndroidObservable() {
    }

    public static <T> Observable<T> bindActivity(Activity activity, Observable<T> source) {
        Assertions.assertUiThread();
        return source.observeOn(AndroidSchedulers.mainThread()).lift(new OperatorConditionalBinding(activity, ACTIVITY_VALIDATOR));
    }

    public static <T> Observable<T> bindFragment(Object fragment, Observable<T> source) {
        Assertions.assertUiThread();
        Observable o = source.observeOn(AndroidSchedulers.mainThread());
        if (USES_SUPPORT_FRAGMENTS && fragment instanceof android.support.v4.app.Fragment) {
            android.support.v4.app.Fragment f = (android.support.v4.app.Fragment)fragment;
            return o.lift(new OperatorConditionalBinding(f, FRAGMENTV4_VALIDATOR));
        }
        if (Build.VERSION.SDK_INT >= 11 && fragment instanceof Fragment) {
            Fragment f = (Fragment)fragment;
            return o.lift(new OperatorConditionalBinding(f, FRAGMENT_VALIDATOR));
        }
        throw new IllegalArgumentException("Target fragment is neither a native nor support library Fragment");
    }

    public static Observable<Intent> fromBroadcast(Context context, IntentFilter filter) {
        return Observable.create((Observable.OnSubscribe)new OperatorBroadcastRegister(context, filter, null, null));
    }

    public static Observable<Intent> fromBroadcast(Context context, IntentFilter filter, String broadcastPermission, Handler schedulerHandler) {
        return Observable.create((Observable.OnSubscribe)new OperatorBroadcastRegister(context, filter, broadcastPermission, schedulerHandler));
    }

    public static Observable<Intent> fromLocalBroadcast(Context context, IntentFilter filter) {
        return Observable.create((Observable.OnSubscribe)new OperatorLocalBroadcastRegister(context, filter));
    }

    static {
        boolean supportFragmentsAvailable = false;
        try {
            Class.forName("android.support.v4.app.Fragment");
            supportFragmentsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_SUPPORT_FRAGMENTS = supportFragmentsAvailable;
        ACTIVITY_VALIDATOR = new Func1<Activity, Boolean>(){

            public Boolean call(Activity activity) {
                return !activity.isFinishing();
            }
        };
        FRAGMENT_VALIDATOR = new Func1<Fragment, Boolean>(){

            public Boolean call(Fragment fragment) {
                return fragment.isAdded() && !fragment.getActivity().isFinishing();
            }
        };
        FRAGMENTV4_VALIDATOR = new Func1<android.support.v4.app.Fragment, Boolean>(){

            public Boolean call(android.support.v4.app.Fragment fragment) {
                return fragment.isAdded() && !fragment.getActivity().isFinishing();
            }
        };
    }
}

