/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.exec.Downstream;
import ratpack.exec.ExecResult;
import ratpack.exec.Result;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.http.TypedData;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.util.Exceptions;

public class BlockingHttpClient {
    public ReceivedResponse request(URI uri, Duration duration, Action<? super RequestSpec> action) throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        try (DefaultExecController execController = new DefaultExecController(2);){
            execController.fork().start(e -> HttpClient.httpClient((ByteBufAllocator)new UnpooledByteBufAllocator(false), (int)Integer.MAX_VALUE).request(uri, action.prepend(s -> s.readTimeout(Duration.ofHours(1L)))).map(response -> {
                TypedData responseBody = response.getBody();
                ByteBuf responseBuffer = responseBody.getBuffer();
                ByteBuf heapResponseBodyBuffer = Unpooled.unreleasableBuffer((ByteBuf)(responseBuffer.isDirect() ? Unpooled.copiedBuffer((ByteBuf)responseBuffer) : responseBuffer.retain()));
                return new DefaultReceivedResponse(response.getStatus(), response.getHeaders(), new ByteBufBackedTypedData(heapResponseBodyBuffer, responseBody.getContentType()));
            }).connect((Downstream)new Downstream<DefaultReceivedResponse>(){

                public void success(DefaultReceivedResponse value) {
                    result.set(ExecResult.of((Result)Result.success((Object)value)));
                    latch.countDown();
                }

                public void error(Throwable throwable) {
                    result.set(ExecResult.of((Result)Result.error((Throwable)throwable)));
                    latch.countDown();
                }

                public void complete() {
                    result.set(ExecResult.complete());
                    latch.countDown();
                }
            }));
            try {
                if (!latch.await(duration.toNanos(), TimeUnit.NANOSECONDS)) {
                    TemporalUnit unit = duration.getUnits().get(0);
                    throw new IllegalStateException("Request to " + uri + " took more than " + duration.get(unit) + " " + unit.toString() + " to complete");
                }
            }
            catch (InterruptedException e2) {
                throw Exceptions.uncheck((Throwable)e2);
            }
            ReceivedResponse receivedResponse = (ReceivedResponse)((ExecResult)result.get()).getValueOrThrow();
            return receivedResponse;
        }
    }
}

