/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.func.Action;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.ManagedSubscription;

public class IterablePublisher<T>
implements TransformablePublisher<T> {
    private final Iterable<? extends T> iterable;

    public IterablePublisher(Iterable<? extends T> iterable) {
        this.iterable = iterable;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Iterator<? extends T> iterator;
        try {
            iterator = this.iterable.iterator();
        }
        catch (Throwable e) {
            subscriber.onError(e);
            return;
        }
        final AtomicBoolean draining = new AtomicBoolean();
        subscriber.onSubscribe((Subscription)new ManagedSubscription<T>(subscriber, Action.noop()){

            @Override
            protected void onRequest(long n) {
                if (draining.compareAndSet(false, true)) {
                    if (this.isDone()) {
                        try {
                            while (iterator.hasNext()) {
                                this.dispose(iterator.next());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    try {
                        while (--n >= 0L && iterator.hasNext() && !this.isDone()) {
                            this.emitNext(iterator.next());
                        }
                    }
                    catch (Exception e) {
                        this.emitError(e);
                        return;
                    }
                    if (!iterator.hasNext()) {
                        this.emitComplete();
                    }
                    draining.set(false);
                    n = this.getDemand();
                    if (n > 0L) {
                        this.onRequest(n);
                    }
                }
            }

            @Override
            protected void onCancel() {
            }
        });
    }
}

