/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Result;

public class CollectingSubscriber<T>
implements Subscriber<T> {
    public final List<T> received = Lists.newLinkedList();
    public Subscription subscription;
    public Throwable error;
    public boolean complete;
    public final Consumer<? super Result<List<T>>> consumer;
    private final Consumer<? super Subscription> subscriptionConsumer;

    public CollectingSubscriber() {
        this(r -> {}, s -> {});
    }

    public CollectingSubscriber(Consumer<? super Result<List<T>>> resultConsumer, Consumer<? super Subscription> subscriptionConsumer) {
        this.consumer = resultConsumer;
        this.subscriptionConsumer = subscriptionConsumer;
    }

    public static <T> CollectingSubscriber<T> subscribe(Publisher<T> publisher) {
        CollectingSubscriber<T> subscriber = new CollectingSubscriber<T>();
        publisher.subscribe(subscriber);
        return subscriber;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.subscriptionConsumer.accept((Subscription)s);
    }

    public void onNext(T t) {
        this.received.add(t);
    }

    public void onError(Throwable t) {
        this.error = t;
        this.consumer.accept(Result.error(t));
    }

    public void onComplete() {
        this.complete = true;
        this.consumer.accept(Result.success(Collections.unmodifiableList(this.received)));
    }
}

