/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;

public class TypeCoercingProperties {
    private final Properties delegate;
    private final ClassLoader classLoader;

    public TypeCoercingProperties(Properties delegate) {
        this(delegate, TypeCoercingProperties.class.getClassLoader());
    }

    public TypeCoercingProperties(Properties delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public String asString(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    public boolean asBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.delegate.getProperty(key, Boolean.toString(defaultValue)));
    }

    public int asInt(String key, int defaultValue) {
        return Integer.parseInt(this.delegate.getProperty(key, Integer.toString(defaultValue)));
    }

    public URI asURI(String key) throws URISyntaxException {
        URI uri = null;
        String uriString = this.delegate.getProperty(key);
        if (uriString != null) {
            uri = new URI(uriString);
        }
        return uri;
    }

    public InetAddress asInetAddress(String key) throws UnknownHostException {
        String addressString = this.delegate.getProperty(key);
        if (addressString == null) {
            return null;
        }
        return InetAddress.getByName(addressString);
    }

    public List<String> asList(String key) {
        String delimitedValues = this.delegate.getProperty(key, "");
        ImmutableList.Builder trimmed = ImmutableList.builder();
        for (String value : delimitedValues.split(",")) {
            if ((value = value.trim()).isEmpty()) continue;
            trimmed.add((Object)value);
        }
        return trimmed.build();
    }

    public InputStream asStream(String key) throws IOException {
        InputStream stream;
        block5: {
            stream = null;
            String path = this.delegate.getProperty(key);
            if (path != null) {
                File file = new File(path);
                if (file.isFile()) {
                    stream = new FileInputStream(file);
                } else {
                    try {
                        URL url = new URL(path);
                        stream = url.openStream();
                    }
                    catch (MalformedURLException e) {
                        stream = this.classLoader.getResourceAsStream(path);
                        if (stream != null) break block5;
                        throw new FileNotFoundException(path);
                    }
                }
            }
        }
        return stream;
    }

    public <T> Class<T> asClass(String key, Class<T> type) throws ClassNotFoundException {
        String className = this.delegate.getProperty(key);
        if (className == null) {
            return null;
        }
        Class<?> untypedClass = this.classLoader.loadClass(className);
        if (!type.isAssignableFrom(untypedClass)) {
            throw new ClassCastException(String.format("Class '%s' does not implement '%s", className, type.getName()));
        }
        return this.classLoader.loadClass(className);
    }
}

