/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.File;
import java.nio.file.Path;
import ratpack.func.Transformer;
import ratpack.handling.Handler;
import ratpack.handling.internal.FactoryHandler;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchException;
import ratpack.launch.internal.LaunchConfigInternal;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.server.RatpackServer;
import ratpack.server.Stopper;
import ratpack.server.internal.NettyRatpackServer;
import ratpack.server.internal.RatpackChannelInitializer;

public abstract class RatpackServerBuilder {
    private RatpackServerBuilder() {
    }

    public static RatpackServer build(LaunchConfig launchConfig) {
        Transformer<Stopper, ChannelInitializer<SocketChannel>> channelInitializer = RatpackServerBuilder.buildChannelInitializer(launchConfig);
        LaunchConfigInternal launchConfigInternal = (LaunchConfigInternal)launchConfig;
        return new NettyRatpackServer(launchConfigInternal, channelInitializer);
    }

    private static Transformer<Stopper, ChannelInitializer<SocketChannel>> buildChannelInitializer(final LaunchConfig launchConfig) {
        return new Transformer<Stopper, ChannelInitializer<SocketChannel>>(){

            @Override
            public ChannelInitializer<SocketChannel> transform(Stopper stopper) {
                return new RatpackChannelInitializer(launchConfig, RatpackServerBuilder.createHandler(launchConfig), stopper);
            }
        };
    }

    private static Handler createHandler(final LaunchConfig launchConfig) {
        File classFile;
        final HandlerFactory handlerFactory = launchConfig.getHandlerFactory();
        if (launchConfig.isReloadable() && (classFile = ClassUtil.getClassFile(handlerFactory)) != null) {
            ReloadableFileBackedFactory<Handler> factory = new ReloadableFileBackedFactory<Handler>(classFile.toPath(), true, new ReloadableFileBackedFactory.Producer<Handler>(){

                @Override
                public Handler produce(Path file, ByteBuf bytes) {
                    return RatpackServerBuilder.createHandler(launchConfig, handlerFactory);
                }
            });
            return new FactoryHandler(factory);
        }
        return RatpackServerBuilder.createHandler(launchConfig, handlerFactory);
    }

    private static Handler createHandler(LaunchConfig launchConfig, HandlerFactory handlerFactory) {
        try {
            return handlerFactory.create(launchConfig);
        }
        catch (Exception e) {
            throw new LaunchException("Could not create handler via handler factory: " + handlerFactory.getClass().getName(), e);
        }
    }
}

