/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import ratpack.http.MediaType;
import ratpack.util.ExceptionUtils;

public class DefaultMediaType
implements MediaType {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String UTF8 = "UTF-8";
    public static final String CHARSET_KEY = "charset";
    private final String type;
    protected final Map<String, String> params;
    private final String string;
    private static final int CACHE_SIZE = 200;
    private static final Cache<String, MediaType> ISO_CACHE = CacheBuilder.newBuilder().maximumSize(200L).build();
    private static final Cache<String, MediaType> UTF8_CACHE = CacheBuilder.newBuilder().maximumSize(200L).build();

    public static MediaType get(String contentType) {
        return DefaultMediaType.fromCache(ISO_CACHE, contentType, DEFAULT_CHARSET);
    }

    public static MediaType utf8(String contentType) {
        return DefaultMediaType.fromCache(UTF8_CACHE, contentType, UTF8);
    }

    private static MediaType fromCache(Cache<String, MediaType> cache, String contentType, final String defaultCharset) {
        contentType = contentType == null ? "" : contentType.trim();
        final String finalContentType = contentType;
        try {
            return (MediaType)cache.get((Object)contentType, (Callable)new Callable<MediaType>(){

                @Override
                public MediaType call() throws Exception {
                    return new DefaultMediaType(finalContentType, defaultCharset);
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    public DefaultMediaType(String value, String defaultCharset) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        boolean setCharset = false;
        if (value == null) {
            this.type = null;
        } else if ((value = value.trim()).length() == 0) {
            this.type = null;
        } else {
            String[] parts = value.split(";");
            this.type = parts[0].toLowerCase();
            if (parts.length > 1) {
                for (int i = 1; i < parts.length; ++i) {
                    String valuePart;
                    String keyPart;
                    String part = parts[i].trim();
                    if (part.contains("=")) {
                        String[] valueSplit = part.split("=", 2);
                        keyPart = valueSplit[0].toLowerCase();
                        valuePart = valueSplit[1];
                        if (keyPart.equals(CHARSET_KEY)) {
                            setCharset = true;
                        }
                    } else {
                        keyPart = part.toLowerCase();
                        valuePart = "";
                    }
                    paramsBuilder.put((Object)keyPart, (Object)valuePart);
                }
            }
        }
        if (!setCharset && this.isText() && !defaultCharset.equals(DEFAULT_CHARSET)) {
            paramsBuilder.put((Object)CHARSET_KEY, (Object)defaultCharset);
        }
        this.params = paramsBuilder.build();
        this.string = this.generateString();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public String getCharset() {
        return this.params.containsKey(CHARSET_KEY) ? this.params.get(CHARSET_KEY) : DEFAULT_CHARSET;
    }

    @Override
    public boolean isText() {
        return this.getType() != null && this.getType().startsWith("text/");
    }

    @Override
    public boolean isJson() {
        return this.getType() != null && this.getType().equals("application/json");
    }

    @Override
    public boolean isForm() {
        return this.getType() != null && this.getType().equals("application/x-www-form-urlencoded");
    }

    @Override
    public boolean isHtml() {
        return this.getType() != null && this.getType().equals("text/html");
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == null;
    }

    public String toString() {
        return this.string;
    }

    private String generateString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.getType());
        for (Map.Entry<String, String> param : this.getParams().entrySet()) {
            s.append(";").append(param.getKey());
            if (param.getValue().isEmpty()) continue;
            s.append("=").append(param.getValue());
        }
        return s.toString();
    }
}

