/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.ConnectionFactoryCreateMethodInvocationSubscriber;
import io.r2dbc.proxy.callback.DefaultConnectionInfo;
import io.r2dbc.proxy.callback.MutableMethodExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.StopWatch;
import io.r2dbc.proxy.core.ProxyEventType;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.lang.reflect.Method;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public final class ConnectionFactoryCallbackHandler
extends CallbackHandlerSupport {
    private final ConnectionFactory connectionFactory;

    public ConnectionFactoryCallbackHandler(ConnectionFactory connectionFactory, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.connectionFactory = Assert.requireNonNull(connectionFactory, "connectionFactory must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        if ("unwrap".equals(methodName)) {
            return this.connectionFactory;
        }
        if ("create".equals(methodName)) {
            ConnectionFactory target = this.connectionFactory;
            StopWatch stopWatch = new StopWatch(this.proxyConfig.getClock());
            MutableMethodExecutionInfo executionInfo = new MutableMethodExecutionInfo();
            executionInfo.setMethod(method);
            executionInfo.setMethodArgs(args);
            executionInfo.setTarget(target);
            Publisher result = (Publisher)this.methodInvocationStrategy.invoke(method, target, args);
            return Mono.from((Publisher)result).transform(Operators.liftPublisher((publisher, subscriber) -> new ConnectionFactoryCreateMethodInvocationSubscriber((CoreSubscriber<Object>)subscriber, executionInfo, this.proxyConfig))).map(resultObj -> {
                executionInfo.setResult(resultObj);
                Connection connection = (Connection)resultObj;
                String connectionId = this.proxyConfig.getConnectionIdManager().getId(connection);
                DefaultConnectionInfo connectionInfo = new DefaultConnectionInfo();
                connectionInfo.setConnectionId(connectionId);
                connectionInfo.setClosed(false);
                connectionInfo.setOriginalConnection(connection);
                executionInfo.setConnectionInfo(connectionInfo);
                Connection proxyConnection = this.proxyConfig.getProxyFactory().wrapConnection(connection, connectionInfo);
                return proxyConnection;
            }).doOnSuccess(o -> {
                executionInfo.setExecuteDuration(stopWatch.getElapsedDuration());
                executionInfo.setThreadName(Thread.currentThread().getName());
                executionInfo.setThreadId(Thread.currentThread().getId());
                executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
                this.proxyConfig.getListeners().afterMethod(executionInfo);
            });
        }
        Object result = this.proceedExecution(method, this.connectionFactory, args, this.proxyConfig.getListeners(), null, null);
        return result;
    }
}

