/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.DefaultConnectionInfo;
import io.r2dbc.proxy.callback.MutableMethodExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.lang.reflect.Method;
import java.util.function.BiFunction;

public final class ConnectionFactoryCallbackHandler
extends CallbackHandlerSupport {
    private final ConnectionFactory connectionFactory;

    public ConnectionFactoryCallbackHandler(ConnectionFactory connectionFactory, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.connectionFactory = Assert.requireNonNull(connectionFactory, "connectionFactory must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        if ("unwrap".equals(methodName)) {
            return this.connectionFactory;
        }
        BiFunction<Object, MutableMethodExecutionInfo, Object> onMap = null;
        if ("create".equals(methodName)) {
            onMap = (resultObj, executionInfo) -> {
                executionInfo.setResult(resultObj);
                Connection connection = (Connection)resultObj;
                String connectionId = this.proxyConfig.getConnectionIdManager().getId(connection);
                DefaultConnectionInfo connectionInfo = new DefaultConnectionInfo();
                connectionInfo.setConnectionId(connectionId);
                connectionInfo.setClosed(false);
                connectionInfo.setOriginalConnection(connection);
                executionInfo.setConnectionInfo(connectionInfo);
                Connection proxyConnection = this.proxyConfig.getProxyFactory().wrapConnection(connection, connectionInfo);
                return proxyConnection;
            };
        }
        Object result = this.proceedExecution(method, this.connectionFactory, args, this.proxyConfig.getListeners(), null, onMap, null);
        return result;
    }
}

