/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecLookup;
import io.r2dbc.postgresql.codec.CodecMetadata;
import io.r2dbc.postgresql.codec.DefaultCodecLookup;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import reactor.util.Logger;
import reactor.util.Loggers;

class CachedCodecLookup
implements CodecLookup {
    private static final Logger LOG = Loggers.getLogger(CachedCodecLookup.class);
    private final Map<Integer, Codec<?>> decodeCodecsCache = new ConcurrentHashMap();
    private final Map<Class<?>, Codec<?>> encodeCodecsCache = new ConcurrentHashMap();
    private final Map<Class<?>, Codec<?>> encodeNullCodecsCache = new ConcurrentHashMap();
    private final CodecLookup delegate;

    public CachedCodecLookup(Iterable<Codec<?>> codecRegistry) {
        this.delegate = new DefaultCodecLookup(codecRegistry);
    }

    public CachedCodecLookup(CodecLookup delegate) {
        Assert.isTrue(!(delegate instanceof CachedCodecLookup), "delegate must not be of type CachedCodecLookup");
        this.delegate = delegate;
    }

    @Override
    public Iterator<Codec<?>> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void afterCodecAdded() {
        this.decodeCodecsCache.clear();
        this.encodeCodecsCache.clear();
        this.encodeNullCodecsCache.clear();
        for (Codec c : this.delegate) {
            if (!(c instanceof CodecMetadata)) continue;
            CodecMetadata metadata = (CodecMetadata)((Object)c);
            this.cacheEncode(c, metadata.type());
            for (PostgresqlObjectId identifier : metadata.getDataTypes()) {
                for (Format format : metadata.getFormats()) {
                    this.cacheDecode(c, metadata.type(), identifier, format);
                }
            }
        }
        for (PostgresqlObjectId identifier : PostgresqlObjectId.values()) {
            for (Format format : Format.all()) {
                Codec<Object> c = this.delegate.findDecodeCodec(identifier.getObjectId(), format, Object.class);
                if (c == null) continue;
                this.cacheDecode(c, Object.class, identifier, format);
            }
        }
    }

    @Override
    public <T> Codec<T> findDecodeCodec(int dataType, Format format, Class<? extends T> type) {
        Integer hash = CachedCodecLookup.generateCodecHash(dataType, format, type);
        return this.findCodec(hash, dataType, format, type, this.decodeCodecsCache, () -> {
            LOG.trace("[codec-finder dataType={}, format={}, type={}] Decode codec not found in cache", new Object[]{dataType, format, type.getName()});
            Codec c = this.delegate.findDecodeCodec(dataType, format, type);
            if (c != null) {
                this.decodeCodecsCache.putIfAbsent(hash, c);
            }
            return c;
        });
    }

    @Override
    public <T> Codec<T> findEncodeCodec(T value) {
        return this.findCodec(value.getClass(), this.encodeCodecsCache, () -> {
            LOG.trace("[codec-finder type={}] Encode codec not found in cache", new Object[]{value.getClass().getName()});
            Codec<Object> c = this.delegate.findEncodeCodec(value);
            if (c != null) {
                this.encodeCodecsCache.putIfAbsent(value.getClass(), c);
            }
            return c;
        });
    }

    @Override
    public <T> Codec<T> findEncodeNullCodec(Class<T> type) {
        return this.findCodec(type, this.encodeNullCodecsCache, () -> {
            LOG.trace("[codec-finder type={}] Encode null codec not found in cache", new Object[]{type.getName()});
            Codec c = this.delegate.findEncodeNullCodec(type);
            if (c != null) {
                this.encodeNullCodecsCache.putIfAbsent(type, c);
            }
            return c;
        });
    }

    private void cacheDecode(Codec<?> c, Class<?> type, PostgresqlObjectId identifier, Format format) {
        Integer decodeHash = CachedCodecLookup.generateCodecHash(identifier.getObjectId(), format, type);
        this.decodeCodecsCache.putIfAbsent(decodeHash, c);
    }

    private void cacheEncode(Codec<?> c, Class<?> type) {
        this.encodeCodecsCache.putIfAbsent(type, c);
        if (c.canEncodeNull(type)) {
            this.encodeNullCodecsCache.putIfAbsent(type, c);
        }
    }

    private synchronized <T> Codec<T> findCodec(Class<?> cacheKey, Map<Class<?>, Codec<?>> cache, Supplier<Codec<T>> fallback) {
        Codec<?> value = cache.get(cacheKey);
        return value != null ? value : fallback.get();
    }

    private synchronized <T> Codec<T> findCodec(Integer cacheKey, int dataType, Format format, Class<? extends T> type, Map<Integer, Codec<?>> cache, Supplier<Codec<T>> fallback) {
        Codec<? extends T> value = cache.get(cacheKey);
        return value != null && value.canDecode(dataType, format, type) ? value : fallback.get();
    }

    private static Integer generateCodecHash(int dataType, Format format, Class<?> type) {
        int result = 1;
        result = 31 * result + dataType;
        result = 31 * result + format.hashCode();
        result = 31 * result + type.hashCode();
        if (type.isArray()) {
            result = 31 * result + type.getComponentType().hashCode();
        }
        return result;
    }
}

