/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.util.Objects;
import javax.ws.rs.RuntimeType;

public interface AdditionalReaderWriter {
    default public void add(Class<?> handlerClass, String mediaType, Class<?> entityClass) {
        this.add(handlerClass, mediaType, entityClass, null);
    }

    public void add(Class<?> var1, String var2, Class<?> var3, RuntimeType var4);

    public static class Entry {
        private final Class<?> handlerClass;
        private final String mediaType;
        private final Class<?> entityClass;
        private final RuntimeType constraint;

        public Entry(Class<?> handlerClass, String mediaType, Class<?> entityClass) {
            this(handlerClass, mediaType, entityClass, null);
        }

        public Entry(Class<?> handlerClass, String mediaType, Class<?> entityClass, RuntimeType constraint) {
            this.handlerClass = Objects.requireNonNull(handlerClass);
            this.mediaType = Objects.requireNonNull(mediaType);
            this.entityClass = Objects.requireNonNull(entityClass);
            this.constraint = constraint;
        }

        public Class<?> getHandlerClass() {
            return this.handlerClass;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public RuntimeType getConstraint() {
            return this.constraint;
        }

        public boolean matchesIgnoringConstraint(Entry other) {
            return this.handlerClass.equals(other.handlerClass) && this.entityClass.equals(other.entityClass) && this.mediaType.equals(other.mediaType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.handlerClass.equals(entry.handlerClass) && this.mediaType.equals(entry.mediaType) && this.entityClass.equals(entry.entityClass) && this.constraint == entry.constraint;
        }

        public int hashCode() {
            return Objects.hash(this.handlerClass, this.mediaType, this.entityClass, this.constraint);
        }
    }
}

