/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.rest.deployment.EntityClassHelper;
import io.quarkus.spring.data.rest.deployment.ResourceMethodsImplementor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.data.repository.ListPagingAndSortingRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

public class RepositoryMethodsImplementor
implements ResourceMethodsImplementor {
    private static final Logger LOGGER = Logger.getLogger(RepositoryMethodsImplementor.class);
    public static final MethodDescriptor GET = MethodDescriptor.ofMethod(CrudRepository.class, (String)"findById", Optional.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor ADD = MethodDescriptor.ofMethod(CrudRepository.class, (String)"save", Object.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor UPDATE = MethodDescriptor.ofMethod(CrudRepository.class, (String)"save", Object.class, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor DELETE = MethodDescriptor.ofMethod(CrudRepository.class, (String)"deleteById", Void.TYPE, (Class[])new Class[]{Object.class});
    public static final MethodDescriptor LIST_ITERABLE = MethodDescriptor.ofMethod(CrudRepository.class, (String)"findAll", Iterable.class, (Class[])new Class[0]);
    public static final MethodDescriptor LIST = MethodDescriptor.ofMethod(ListCrudRepository.class, (String)"findAll", List.class, (Class[])new Class[0]);
    public static final MethodDescriptor LIST_BY_ID = MethodDescriptor.ofMethod(ListCrudRepository.class, (String)"findAllById", List.class, (Class[])new Class[]{Iterable.class});
    public static final MethodDescriptor SAVE_LIST = MethodDescriptor.ofMethod(ListCrudRepository.class, (String)"saveAll", List.class, (Class[])new Class[]{Iterable.class});
    public static final MethodDescriptor LIST_PAGED = MethodDescriptor.ofMethod(PagingAndSortingRepository.class, (String)"findAll", Page.class, (Class[])new Class[]{Pageable.class});
    private static final Class<?> PANACHE_PAGE = io.quarkus.panache.common.Page.class;
    private static final Class<?> PANACHE_SORT = Sort.class;
    private static final Class<?> PANACHE_COLUMN = Sort.Column.class;
    private static final Class<?> PANACHE_DIRECTION = Sort.Direction.class;
    public static final DotName CRUD_REPOSITORY_INTERFACE = DotName.createSimple((String)CrudRepository.class.getName());
    public static final DotName LIST_CRUD_REPOSITORY_INTERFACE = DotName.createSimple((String)ListCrudRepository.class.getName());
    public static final DotName PAGING_AND_SORTING_REPOSITORY_INTERFACE = DotName.createSimple((String)PagingAndSortingRepository.class.getName());
    public static final DotName LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE = DotName.createSimple((String)ListPagingAndSortingRepository.class.getName());
    public static final DotName JPA_REPOSITORY_INTERFACE = DotName.createSimple((String)JpaRepository.class.getName());
    protected final EntityClassHelper entityClassHelper;

    public RepositoryMethodsImplementor(IndexView index, EntityClassHelper entityClassHelper) {
        this.entityClassHelper = entityClassHelper;
    }

    @Override
    public void implementIterable(ClassCreator classCreator, String repositoryInterfaceName) {
        if (this.entityClassHelper.isCrudRepository(repositoryInterfaceName) && !this.entityClassHelper.isPagingAndSortingRepository(repositoryInterfaceName)) {
            MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{io.quarkus.panache.common.Page.class, Sort.class, String.class, Map.class});
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(LIST_ITERABLE, repository, new ResultHandle[0]);
            methodCreator.returnValue(result);
            LOGGER.debugf("Method code: %s ", (Object)methodCreator.getMethodDescriptor().toString());
            methodCreator.close();
        }
    }

    @Override
    public void implementList(ClassCreator classCreator, String repositoryInterfaceName) {
        if (this.entityClassHelper.isListCrudRepository(repositoryInterfaceName) && !this.entityClassHelper.isListPagingAndSortingRepository(repositoryInterfaceName)) {
            MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{io.quarkus.panache.common.Page.class, Sort.class, String.class, Map.class});
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(LIST, repository, new ResultHandle[0]);
            methodCreator.returnValue(result);
            LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
            methodCreator.close();
        }
    }

    @Override
    public void implementPagedList(ClassCreator classCreator, String repositoryInterfaceName) {
        if (this.entityClassHelper.isPagingAndSortingRepository(repositoryInterfaceName)) {
            MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{io.quarkus.panache.common.Page.class, Sort.class, String.class, Map.class});
            ResultHandle page = methodCreator.getMethodParam(0);
            ResultHandle sort = methodCreator.getMethodParam(1);
            ResultHandle pageable = this.toPageable(methodCreator, page, sort);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle resultPage = methodCreator.invokeInterfaceMethod(LIST_PAGED, repository, new ResultHandle[]{pageable});
            ResultHandle result = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Page.class, (String)"getContent", List.class, (Class[])new Class[0]), resultPage, new ResultHandle[0]);
            methodCreator.returnValue(result);
            LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
            methodCreator.close();
        }
    }

    @Override
    public void implementListPageCount(ClassCreator classCreator, String repositoryInterfaceName) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Integer.TYPE, new Class[]{io.quarkus.panache.common.Page.class, String.class, Map.class});
        if (this.entityClassHelper.isPagingAndSortingRepository(repositoryInterfaceName)) {
            ResultHandle page = methodCreator.getMethodParam(0);
            ResultHandle pageable = this.toPageable(methodCreator, page);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle resultPage = methodCreator.invokeInterfaceMethod(LIST_PAGED, repository, new ResultHandle[]{pageable});
            ResultHandle pageCount = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Page.class, (String)"getTotalPages", Integer.TYPE, (Class[])new Class[0]), resultPage, new ResultHandle[0]);
            methodCreator.returnValue(pageCount);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    @Override
    public void implementListById(ClassCreator classCreator, String repositoryInterfaceName) {
        if (this.entityClassHelper.isListCrudRepository(repositoryInterfaceName)) {
            MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{Iterable.class});
            ResultHandle ids = methodCreator.getMethodParam(0);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(LIST_BY_ID, repository, new ResultHandle[]{ids});
            methodCreator.returnValue(result);
            LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
            methodCreator.close();
        }
    }

    @Override
    public void implementGet(ClassCreator classCreator, String repositoryInterfaceName) {
        MethodCreator methodCreator = classCreator.getMethodCreator("get", Object.class, new Class[]{Object.class});
        if (this.entityClassHelper.isCrudRepository(repositoryInterfaceName)) {
            ResultHandle id = methodCreator.getMethodParam(0);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = this.findById((BytecodeCreator)methodCreator, id, repository);
            methodCreator.returnValue(result);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    @Override
    public void implementAdd(ClassCreator classCreator, String repositoryInterfaceName) {
        MethodCreator methodCreator = classCreator.getMethodCreator("add", Object.class, new Class[]{Object.class});
        if (this.entityClassHelper.isCrudRepository(repositoryInterfaceName)) {
            ResultHandle entity = methodCreator.getMethodParam(0);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(ADD, repository, new ResultHandle[]{entity});
            methodCreator.returnValue(result);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    @Override
    public void implementAddList(ClassCreator classCreator, String repositoryInterfaceName) {
        MethodCreator methodCreator = classCreator.getMethodCreator("addAll", List.class, new Class[]{Iterable.class});
        if (this.entityClassHelper.isListCrudRepository(repositoryInterfaceName)) {
            ResultHandle entity = methodCreator.getMethodParam(0);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(SAVE_LIST, repository, new ResultHandle[]{entity});
            methodCreator.returnValue(result);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    @Override
    public void implementUpdate(ClassCreator classCreator, String repositoryInterfaceName, String entityType) {
        MethodCreator methodCreator = classCreator.getMethodCreator("update", Object.class, new Class[]{Object.class, Object.class});
        if (this.entityClassHelper.isCrudRepository(repositoryInterfaceName)) {
            ResultHandle id = methodCreator.getMethodParam(0);
            ResultHandle entity = methodCreator.getMethodParam(1);
            this.setId((BytecodeCreator)methodCreator, entityType, entity, id);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle result = methodCreator.invokeInterfaceMethod(UPDATE, repository, new ResultHandle[]{entity});
            methodCreator.returnValue(result);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    @Override
    public void implementDelete(ClassCreator classCreator, String repositoryInterfaceName) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Boolean.TYPE, new Class[]{Object.class});
        if (this.entityClassHelper.isCrudRepository(repositoryInterfaceName)) {
            ResultHandle id = methodCreator.getMethodParam(0);
            ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterfaceName);
            ResultHandle entity = this.findById((BytecodeCreator)methodCreator, id, repository);
            AssignableResultHandle result = methodCreator.createVariable(Boolean.TYPE);
            BranchResult entityExists = methodCreator.ifNotNull(entity);
            entityExists.trueBranch().invokeInterfaceMethod(DELETE, repository, new ResultHandle[]{id});
            entityExists.trueBranch().assign(result, entityExists.trueBranch().load(true));
            entityExists.falseBranch().assign(result, entityExists.falseBranch().load(false));
            methodCreator.returnValue((ResultHandle)result);
        } else {
            methodCreator.throwException(RuntimeException.class, "Method not implemented");
        }
        LOGGER.debugf("Method code: %s ", (Object)methodCreator.toString());
        methodCreator.close();
    }

    private ResultHandle findById(BytecodeCreator creator, ResultHandle id, ResultHandle repository) {
        ResultHandle optional = creator.invokeInterfaceMethod(GET, repository, new ResultHandle[]{id});
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"orElse", Object.class, (Class[])new Class[]{Object.class}), optional, new ResultHandle[]{creator.loadNull()});
    }

    private void setId(BytecodeCreator creator, String entityType, ResultHandle entity, ResultHandle id) {
        FieldInfo idField = this.entityClassHelper.getIdField(entityType);
        MethodDescriptor idSetter = this.entityClassHelper.getSetter(entityType, idField);
        creator.invokeVirtualMethod(idSetter, entity, new ResultHandle[]{id});
    }

    private ResultHandle toPageable(MethodCreator creator, ResultHandle panachePage) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"index", Integer.TYPE), panachePage);
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"size", Integer.TYPE), panachePage);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PageRequest.class, (String)"of", PageRequest.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{index, size});
    }

    private ResultHandle toPageable(MethodCreator creator, ResultHandle panachePage, ResultHandle panacheSort) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"index", Integer.TYPE), panachePage);
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"size", Integer.TYPE), panachePage);
        ResultHandle springSort = this.toSpringSort(creator, panacheSort);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PageRequest.class, (String)"of", PageRequest.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, org.springframework.data.domain.Sort.class}), new ResultHandle[]{index, size, springSort});
    }

    private ResultHandle toSpringSort(MethodCreator creator, ResultHandle panacheSort) {
        AssignableResultHandle springSort = creator.createVariable(org.springframework.data.domain.Sort.class);
        creator.assign(springSort, creator.invokeStaticMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"unsorted", org.springframework.data.domain.Sort.class, (Class[])new Class[0]), new ResultHandle[0]));
        ResultHandle columns = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_SORT, (String)"getColumns", List.class, (Class[])new Class[0]), panacheSort, new ResultHandle[0]);
        ResultHandle columnsIterator = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BytecodeCreator loopCreator = creator.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, columnsIterator)).block();
        ResultHandle column = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), columnsIterator, new ResultHandle[0]);
        this.addColumn(loopCreator, springSort, column);
        return springSort;
    }

    private BranchResult iteratorHasNext(BytecodeCreator creator, ResultHandle iterator) {
        return creator.ifTrue(creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]));
    }

    private void addColumn(BytecodeCreator creator, AssignableResultHandle springSort, ResultHandle column) {
        ResultHandle orderArray = creator.newArray(Sort.Order.class, 1);
        this.setOrder(creator, orderArray, column);
        ResultHandle subSort = creator.invokeStaticMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"by", org.springframework.data.domain.Sort.class, (Class[])new Class[]{Sort.Order[].class}), new ResultHandle[]{orderArray});
        creator.assign(springSort, creator.invokeVirtualMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"and", org.springframework.data.domain.Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), (ResultHandle)springSort, new ResultHandle[]{subSort}));
    }

    private void setOrder(BytecodeCreator creator, ResultHandle orderArray, ResultHandle column) {
        ResultHandle columnName = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_COLUMN, (String)"getName", String.class, (Class[])new Class[0]), column, new ResultHandle[0]);
        ResultHandle direction = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_COLUMN, (String)"getDirection", PANACHE_DIRECTION, (Class[])new Class[0]), column, new ResultHandle[0]);
        BranchResult isAscendingBranch = this.isAscending(creator, direction);
        isAscendingBranch.trueBranch().writeArrayValue(orderArray, 0, isAscendingBranch.trueBranch().invokeStaticMethod(MethodDescriptor.ofMethod(Sort.Order.class, (String)"asc", Sort.Order.class, (Class[])new Class[]{String.class}), new ResultHandle[]{columnName}));
        isAscendingBranch.falseBranch().writeArrayValue(orderArray, 0, isAscendingBranch.falseBranch().invokeStaticMethod(MethodDescriptor.ofMethod(Sort.Order.class, (String)"desc", Sort.Order.class, (Class[])new Class[]{String.class}), new ResultHandle[]{columnName}));
    }

    private BranchResult isAscending(BytecodeCreator creator, ResultHandle panacheDirection) {
        ResultHandle ascending = creator.invokeStaticMethod(MethodDescriptor.ofMethod(PANACHE_DIRECTION, (String)"valueOf", PANACHE_DIRECTION, (Class[])new Class[]{String.class}), new ResultHandle[]{creator.load("Ascending")});
        return creator.ifTrue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_DIRECTION, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), ascending, new ResultHandle[]{panacheDirection}));
    }
}

