/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cache;

import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

final class SpringCacheUtil {
    private SpringCacheUtil() {
    }

    static Optional<String> getSpringCacheName(AnnotationInstance annotationInstance) {
        AnnotationValue value;
        String cacheName = null;
        AnnotationValue cacheNameValue = annotationInstance.value("cacheNames");
        if (cacheNameValue != null) {
            cacheName = SpringCacheUtil.singleName(cacheNameValue, annotationInstance.target());
        }
        if ((cacheName == null || cacheName.isEmpty()) && (value = annotationInstance.value()) != null) {
            cacheName = SpringCacheUtil.singleName(value, annotationInstance.target());
        }
        return cacheName == null || cacheName.isEmpty() ? Optional.empty() : Optional.of(cacheName);
    }

    private static String singleName(AnnotationValue annotationValue, AnnotationTarget target) {
        if (annotationValue.kind() != AnnotationValue.Kind.ARRAY) {
            return null;
        }
        String[] strings = annotationValue.asStringArray();
        if (strings.length == 0) {
            return null;
        }
        if (strings.length > 1) {
            throw new IllegalArgumentException(String.format("Quarkus currently only supports using a single cache name. Offending %s is %s", target.kind() == AnnotationTarget.Kind.METHOD ? "method" : "class", target.toString()));
        }
        return strings[0];
    }
}

