/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.smallrye.openapi.runtime.OpenAPIRuntimeBuilder;
import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentHolder;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import io.quarkus.smallrye.openapi.runtime.filter.DisabledRestEndpointsFilter;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

@ApplicationScoped
public class OpenApiDocumentService {
    private final OpenApiDocumentHolder documentHolder;

    @Inject
    public OpenApiDocumentService(OASFilter autoSecurityFilter, OpenApiRecorder.UserDefinedRuntimeFilters runtimeFilters, Config config) {
        ClassLoader loader = Optional.ofNullable(OpenApiConstants.classLoader).orElseGet(Thread.currentThread()::getContextClassLoader);
        try (InputStream source = loader.getResourceAsStream("META-INF/quarkus-generated-openapi-doc.JSON");){
            if (source != null) {
                LinkedHashSet<String> userFilters = new LinkedHashSet<String>(runtimeFilters.filters());
                boolean dynamic = config.getOptionalValue("quarkus.smallrye-openapi.always-run-filter", Boolean.class).orElse(Boolean.FALSE);
                SmallRyeOpenAPI.Builder builder = new OpenAPIRuntimeBuilder().withConfig(config).withApplicationClassLoader(loader).enableModelReader(false).enableStandardStaticFiles(false).enableAnnotationScan(false).enableStandardFilter(false).withCustomStaticFile(() -> source);
                Optional.ofNullable(autoSecurityFilter).ifPresent(arg_0 -> ((SmallRyeOpenAPI.Builder)builder).addFilter(arg_0));
                DisabledRestEndpointsFilter.maybeGetInstance().ifPresent(arg_0 -> ((SmallRyeOpenAPI.Builder)builder).addFilter(arg_0));
                if (dynamic && !userFilters.isEmpty()) {
                    this.documentHolder = new DynamicDocument(builder, loader, userFilters);
                } else {
                    userFilters.forEach(name -> builder.addFilter(name, loader, (IndexView)null));
                    this.documentHolder = new StaticDocument(builder.build());
                }
            } else {
                this.documentHolder = new EmptyDocument();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    byte[] getDocument(Format format) {
        if (format.equals((Object)Format.JSON)) {
            return this.documentHolder.getJsonDocument();
        }
        return this.documentHolder.getYamlDocument();
    }

    static class DynamicDocument
    implements OpenApiDocumentHolder {
        private SmallRyeOpenAPI.Builder builder;

        DynamicDocument(SmallRyeOpenAPI.Builder builder, ClassLoader loader, Set<String> userFilters) {
            OpenAPI generatedOnBuild = builder.build().model();
            builder.withCustomStaticFile(() -> null);
            builder.withInitialModel(generatedOnBuild);
            userFilters.forEach(name -> builder.addFilter(name, loader, (IndexView)null));
            this.builder = builder;
        }

        @Override
        public byte[] getJsonDocument() {
            return this.builder.build().toJSON().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public byte[] getYamlDocument() {
            return this.builder.build().toYAML().getBytes(StandardCharsets.UTF_8);
        }
    }

    static class StaticDocument
    implements OpenApiDocumentHolder {
        private byte[] jsonDocument;
        private byte[] yamlDocument;

        StaticDocument(SmallRyeOpenAPI openAPI) {
            this.jsonDocument = openAPI.toJSON().getBytes(StandardCharsets.UTF_8);
            this.yamlDocument = openAPI.toYAML().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public byte[] getJsonDocument() {
            return this.jsonDocument;
        }

        @Override
        public byte[] getYamlDocument() {
            return this.yamlDocument;
        }
    }

    static class EmptyDocument
    implements OpenApiDocumentHolder {
        static final byte[] EMPTY = new byte[0];

        EmptyDocument() {
        }

        @Override
        public byte[] getJsonDocument() {
            return EMPTY;
        }

        @Override
        public byte[] getYamlDocument() {
            return EMPTY;
        }
    }
}

