/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.dev;

import graphql.schema.GraphQLSchema;
import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.runtime.annotations.DevMCPEnableByDefault;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.smallrye.graphql.execution.SchemaPrinter;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class GraphQLJsonRpcService {
    private final SchemaPrinter schemaPrinter = new SchemaPrinter();
    @Inject
    GraphQLSchema graphQLSchema;
    @Inject
    Optional<Assistant> assistant;
    private static final String USER_MESSAGE = "Given the GraphQL Schema document :\n\n```json\n{{schemaDocument}}\n```\n\nPlease generate a {{language}} Object that act as a client to all the operations in the schema.\nThis {{language}} code must be able to be called like this (pseudo code):\n\n```\nvar stub = new ResourceNameHereClient();\nvar response = stub.doOperation(someparam);\n```\n\nYour reponse should only contain one field called `code` that contains a value with only the {{language}} code, nothing else, no explanation, and do not put the code in backticks.\nThe {{language}} code must run and be valid.\n\nExample response: `{code: 'package foo.bar; // more code here'}`\n\n{{extraContext}}\n";

    @JsonRpcDescription(value="Get the running application's GraphQL Schema Document")
    @DevMCPEnableByDefault
    public String getGraphQLSchema() {
        return this.schemaPrinter.print(this.graphQLSchema);
    }

    public CompletionStage<Map<String, String>> generateClient(String language, String extraContext) {
        if (this.assistant.isPresent()) {
            String schemaDocument = this.getGraphQLSchema();
            return this.assistant.get().assistBuilder().userMessage(USER_MESSAGE).addVariable("schemaDocument", schemaDocument).addVariable("language", language).addVariable("extraContext", extraContext).responseType(GraphQLClientResponse.class).assist();
        }
        return CompletableFuture.failedStage(new RuntimeException("Assistant is not available"));
    }

    record GraphQLClientResponse(String code) {
    }
}

