/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.test.utils;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.test.utils.AuthData;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;

@Alternative
@ApplicationScoped
@Priority(value=1)
public class IdentityMock
implements SecurityIdentity {
    public static final AuthData ANONYMOUS = new AuthData(null, true, null);
    public static final AuthData USER = new AuthData(Collections.singleton("user"), false, "user");
    public static final AuthData ADMIN = new AuthData(Collections.singleton("admin"), false, "admin");
    private static volatile boolean anonymous;
    private static volatile Set<String> roles;
    private static volatile String name;

    public static void setUpAuth(AuthData auth) {
        anonymous = auth.anonymous;
        roles = auth.roles;
        name = auth.name;
    }

    public Principal getPrincipal() {
        return new Principal(){

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public boolean hasRole(String role) {
        if (roles == null) {
            return false;
        }
        return this.getRoles().contains(role);
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public <T extends Credential> T getCredential(Class<T> aClass) {
        return null;
    }

    public Set<Credential> getCredentials() {
        return null;
    }

    public <T> T getAttribute(String s) {
        return null;
    }

    public Map<String, Object> getAttributes() {
        return null;
    }

    public Uni<Boolean> checkPermission(Permission permission) {
        return null;
    }
}

