/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.dev;

import io.quarkus.hibernate.orm.dev.HibernateOrmDevController;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateOrmDevIntegrator
implements Integrator {
    public void integrate(Metadata metadata, BootstrapContext bootstrapContext, SessionFactoryImplementor sf) {
        String name = (String)sf.getProperties().get("hibernate.persistenceUnitName");
        HibernateOrmDevController.get().pushPersistenceUnit(sf, HibernateOrmDevIntegrator.getPersistenceUnitDescriptor(name, sf), name, metadata, (ServiceRegistry)sf.getServiceRegistry(), (String)sf.getProperties().get("jakarta.persistence.sql-load-script-source"));
    }

    private static QuarkusPersistenceUnitDescriptor getPersistenceUnitDescriptor(String name, SessionFactoryImplementor sf) {
        boolean isReactive = sf.getClass().getPackage().getName().contains("reactive");
        return PersistenceUnitsHolder.getPersistenceUnitDescriptor((String)name, (boolean)isReactive);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
        HibernateOrmDevController.get().clearData();
    }
}

