/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.handler.logging.LogLevel;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import java.util.function.Function;

class VertxHttp2ConnectionHandlerBuilder<C extends Http2ConnectionBase>
extends AbstractHttp2ConnectionHandlerBuilder<VertxHttp2ConnectionHandler<C>, VertxHttp2ConnectionHandlerBuilder<C>> {
    private boolean useUniformStreamByteDistributor;
    private boolean useDecompression;
    private CompressionOptions[] compressionOptions;
    private Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory;
    private boolean logEnabled;
    private boolean server;

    VertxHttp2ConnectionHandlerBuilder() {
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> server(boolean isServer) {
        this.server = isServer;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> initialSettings(Http2Settings settings) {
        HttpUtils.fromVertxInitialSettings(this.server, settings, this.initialSettings());
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useCompression(CompressionOptions[] compressionOptions) {
        this.compressionOptions = compressionOptions;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useUniformStreamByteDistributor(boolean useUniformStreamByteDistributor) {
        this.useUniformStreamByteDistributor = useUniformStreamByteDistributor;
        return this;
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> decoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        return (VertxHttp2ConnectionHandlerBuilder)super.decoderEnforceMaxRstFramesPerWindow(maxRstFramesPerWindow, secondsPerWindow);
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> encoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        return (VertxHttp2ConnectionHandlerBuilder)super.encoderEnforceMaxRstFramesPerWindow(maxRstFramesPerWindow, secondsPerWindow);
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        return (VertxHttp2ConnectionHandlerBuilder)super.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
    }

    VertxHttp2ConnectionHandlerBuilder<C> useDecompression(boolean useDecompression) {
        this.useDecompression = useDecompression;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> connectionFactory(Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    @Override
    protected VertxHttp2ConnectionHandler<C> build() {
        if (this.logEnabled) {
            this.frameLogger(new Http2FrameLogger(LogLevel.DEBUG));
        }
        this.configureStreamByteDistributor();
        this.frameListener(new Http2FrameListener(){

            @Override
            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings settings) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
                throw new UnsupportedOperationException();
            }
        });
        return (VertxHttp2ConnectionHandler)super.build();
    }

    private void configureStreamByteDistributor() {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(this.server, this.maxReservedStreams());
        StreamByteDistributor distributor = this.useUniformStreamByteDistributor ? new UniformStreamByteDistributor(conn) : new WeightedFairQueueByteDistributor(conn);
        conn.remote().flowController(new DefaultHttp2RemoteFlowController((Http2Connection)conn, distributor));
        this.connection(conn);
    }

    @Override
    protected VertxHttp2ConnectionHandler<C> build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
        if (this.server) {
            if (this.compressionOptions != null) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, this.compressionOptions);
            }
            VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
            decoder.frameListener(handler);
            return handler;
        }
        VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
        decoder.frameListener(handler);
        return handler;
    }
}

