/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.model.cloudevents;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.quarkus.funqy.lambda.model.cloudevents.CloudEventDataV1;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CloudEventV1
implements CloudEvent {
    private final CloudEventDataV1 data;
    private final SpecVersion specVersion;
    private final String id;
    private final String type;
    private final URI source;
    private final String dataContentType;
    private final URI dataSchema;
    private final String subject;
    private final OffsetDateTime time;
    private final Map<String, Object> extensions;

    public CloudEventV1(@JsonProperty(value="specversion") String specVersion, @JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="source") URI source, @JsonProperty(value="datacontenttype") String dataContentType, @JsonProperty(value="dataschema") URI dataSchema, @JsonProperty(value="subject") String subject, @JsonProperty(value="time") OffsetDateTime time, @JsonProperty(value="data") JsonNode data, @JsonProperty(value="data_base64") JsonNode dataBase64) {
        this.specVersion = SpecVersion.parse((String)specVersion);
        this.id = id;
        this.type = type;
        this.source = source;
        this.dataContentType = dataContentType;
        this.dataSchema = dataSchema;
        this.subject = subject;
        this.time = time;
        this.extensions = new HashMap<String, Object>();
        this.data = this.deserializeData(data, dataBase64, dataContentType);
    }

    @JsonAnySetter
    public void add(String property, String value) {
        switch (property) {
            case "specversion": 
            case "id": 
            case "source": 
            case "type": 
            case "datacontenttype": 
            case "dataschema": 
            case "data": 
            case "data_base64": 
            case "subject": 
            case "time": {
                return;
            }
        }
        this.extensions.put(property, value);
    }

    private CloudEventDataV1 deserializeData(JsonNode data, JsonNode dataBase64, String dataContentType) {
        if (dataBase64 != null) {
            try {
                return new CloudEventDataV1(dataBase64.binaryValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (data == null) {
            return null;
        }
        if (data.isTextual()) {
            return new CloudEventDataV1(data.asText());
        }
        return new CloudEventDataV1(data.toString());
    }

    public CloudEventData getData() {
        return this.data;
    }

    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public URI getSource() {
        return this.source;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public URI getDataSchema() {
        return this.dataSchema;
    }

    public String getSubject() {
        return this.subject;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public Object getAttribute(String attributeName) throws IllegalArgumentException {
        return switch (attributeName) {
            case "specversion" -> this.getSpecVersion();
            case "id" -> this.getId();
            case "source" -> this.getSource();
            case "type" -> this.getType();
            case "datacontenttype" -> this.getDataContentType();
            case "dataschema" -> this.getDataSchema();
            case "subject" -> this.getSubject();
            case "time" -> this.getTime();
            default -> throw new IllegalArgumentException("The specified attribute name \"" + attributeName + "\" is not specified in version v1.");
        };
    }

    public Object getExtension(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Extension name cannot be null");
        }
        return this.extensions.get(s);
    }

    public Set<String> getExtensionNames() {
        return this.extensions.keySet();
    }
}

