/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event.cloudevents;

import io.cloudevents.CloudEvent;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventHandler;
import io.quarkus.funqy.lambda.model.pipes.BatchItemFailures;
import io.quarkus.funqy.lambda.model.pipes.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CloudEventsHandler
implements EventHandler<List<CloudEvent>, CloudEvent, Response> {
    @Override
    public Stream<CloudEvent> streamEvent(List<CloudEvent> event, FunqyAmazonConfig amazonConfig) {
        if (event == null) {
            return Stream.empty();
        }
        return event.stream();
    }

    @Override
    public String getIdentifier(CloudEvent message, FunqyAmazonConfig amazonConfig) {
        return message.getId();
    }

    @Override
    public Supplier<InputStream> getBody(CloudEvent message, FunqyAmazonConfig amazonConfig) {
        return () -> new ByteArrayInputStream(message.getData().toBytes());
    }

    @Override
    public Response createResponse(List<String> failures, FunqyAmazonConfig amazonConfig) {
        if (!amazonConfig.advancedEventHandling().sqs().reportBatchItemFailures()) {
            return null;
        }
        return new Response(failures.stream().map(BatchItemFailures::new).toList());
    }

    @Override
    public Class<CloudEvent> getMessageClass() {
        return CloudEvent.class;
    }
}

