/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocGeneratedOutput;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import io.quarkus.annotation.processor.generate_doc.SummaryTableDocFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public final class ConfigDocWriter {
    private final DocFormatter summaryTableDocFormatter = new SummaryTableDocFormatter();

    public void writeAllExtensionConfigDocumentation(ConfigDocGeneratedOutput output) throws IOException {
        this.generateDocumentation(Constants.GENERATED_DOCS_PATH.resolve(output.getFileName()), output.getAnchorPrefix(), output.isSearchable(), output.getConfigDocItems());
    }

    private void generateDocumentation(Path targetPath, String initialAnchorPrefix, boolean activateSearch, List<ConfigDocItem> configDocItems) throws IOException {
        if (configDocItems.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, new OpenOption[0]);){
            this.summaryTableDocFormatter.format(writer, initialAnchorPrefix, activateSearch, configDocItems);
            boolean hasDuration = false;
            boolean hasMemory = false;
            for (ConfigDocItem item : configDocItems) {
                if (item.hasDurationInformationNote()) {
                    hasDuration = true;
                }
                if (!item.hasMemoryInformationNote()) continue;
                hasMemory = true;
            }
            if (hasDuration) {
                writer.append("\n[NOTE]\n[[duration-note-anchor]]\n.About the Duration format\n====\nThe format for durations uses the standard `java.time.Duration` format.\nYou can learn more about it in the link:https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html#parse-java.lang.CharSequence-[Duration#parse() javadoc].\n\nYou can also provide duration values starting with a number.\nIn this case, if the value consists only of a number, the converter treats the value as seconds.\nOtherwise, `PT` is implicitly prepended to the value to obtain a standard `java.time.Duration` format.\n====\n");
            }
            if (hasMemory) {
                writer.append("\n[NOTE]\n[[memory-size-note-anchor]]\n.About the MemorySize format\n====\nA size configuration option recognises string in this format (shown as a regular expression): `[0-9]+[KkMmGgTtPpEeZzYy]?`.\nIf no suffix is given, assume bytes.\n====\n");
            }
        }
    }
}

