/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

@ApplicationScoped
public class ElytronPasswordIdentityProvider
implements IdentityProvider<UsernamePasswordAuthenticationRequest> {
    private static Logger log = Logger.getLogger(ElytronPasswordIdentityProvider.class);
    @Inject
    SecurityDomain domain;

    public Class<UsernamePasswordAuthenticationRequest> getRequestType() {
        return UsernamePasswordAuthenticationRequest.class;
    }

    public Uni<io.quarkus.security.identity.SecurityIdentity> authenticate(final UsernamePasswordAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<io.quarkus.security.identity.SecurityIdentity>(){

            @Override
            public io.quarkus.security.identity.SecurityIdentity get() {
                try {
                    SecurityIdentity result = ElytronPasswordIdentityProvider.this.domain.authenticate(request.getUsername(), (Evidence)new PasswordGuessEvidence(request.getPassword().getPassword()));
                    if (result == null) {
                        throw new AuthenticationFailedException();
                    }
                    QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                    builder.setPrincipal(result.getPrincipal());
                    for (String i : result.getRoles()) {
                        builder.addRole(i);
                    }
                    builder.addCredential((Credential)request.getPassword());
                    return builder.build();
                }
                catch (RealmUnavailableException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException((Throwable)e);
                }
            }
        });
    }
}

